package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeletePackageResponse(
    deletedPackage: Optional[zio.aws.codeartifact.model.PackageSummary] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.DeletePackageResponse = {
    import DeletePackageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.DeletePackageResponse
      .builder()
      .optionallyWith(deletedPackage.map(value => value.buildAwsValue()))(
        _.deletedPackage
      )
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.DeletePackageResponse.ReadOnly =
    zio.aws.codeartifact.model.DeletePackageResponse.wrap(buildAwsValue())
}
object DeletePackageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.DeletePackageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.DeletePackageResponse =
      zio.aws.codeartifact.model
        .DeletePackageResponse(deletedPackage.map(value => value.asEditable))
    def deletedPackage
        : Optional[zio.aws.codeartifact.model.PackageSummary.ReadOnly]
    def getDeletedPackage: ZIO[
      Any,
      AwsError,
      zio.aws.codeartifact.model.PackageSummary.ReadOnly
    ] = AwsError.unwrapOptionField("deletedPackage", deletedPackage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.DeletePackageResponse
  ) extends zio.aws.codeartifact.model.DeletePackageResponse.ReadOnly {
    override val deletedPackage
        : Optional[zio.aws.codeartifact.model.PackageSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletedPackage())
        .map(value => zio.aws.codeartifact.model.PackageSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.DeletePackageResponse
  ): zio.aws.codeartifact.model.DeletePackageResponse.ReadOnly = new Wrapper(
    impl
  )
}
