package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeRepositoryResponse(
    repository: Optional[zio.aws.codeartifact.model.RepositoryDescription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.DescribeRepositoryResponse = {
    import DescribeRepositoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.DescribeRepositoryResponse
      .builder()
      .optionallyWith(repository.map(value => value.buildAwsValue()))(
        _.repository
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.DescribeRepositoryResponse.ReadOnly =
    zio.aws.codeartifact.model.DescribeRepositoryResponse.wrap(buildAwsValue())
}
object DescribeRepositoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.DescribeRepositoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.DescribeRepositoryResponse =
      zio.aws.codeartifact.model
        .DescribeRepositoryResponse(repository.map(value => value.asEditable))
    def repository
        : Optional[zio.aws.codeartifact.model.RepositoryDescription.ReadOnly]
    def getRepository: ZIO[
      Any,
      AwsError,
      zio.aws.codeartifact.model.RepositoryDescription.ReadOnly
    ] = AwsError.unwrapOptionField("repository", repository)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.DescribeRepositoryResponse
  ) extends zio.aws.codeartifact.model.DescribeRepositoryResponse.ReadOnly {
    override val repository
        : Optional[zio.aws.codeartifact.model.RepositoryDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repository())
        .map(value =>
          zio.aws.codeartifact.model.RepositoryDescription.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.DescribeRepositoryResponse
  ): zio.aws.codeartifact.model.DescribeRepositoryResponse.ReadOnly =
    new Wrapper(impl)
}
