package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeartifact.model.primitives.{PackageName, PackageNamespace}
import scala.jdk.CollectionConverters.*
final case class PackageSummary(
    format: Optional[zio.aws.codeartifact.model.PackageFormat] =
      Optional.Absent,
    namespace: Optional[PackageNamespace] = Optional.Absent,
    packageValue: Optional[PackageName] = Optional.Absent,
    originConfiguration: Optional[
      zio.aws.codeartifact.model.PackageOriginConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.PackageSummary = {
    import PackageSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.PackageSummary
      .builder()
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(
        namespace.map(value => PackageNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        packageValue.map(value => PackageName.unwrap(value): java.lang.String)
      )(_.packageValue)
      .optionallyWith(originConfiguration.map(value => value.buildAwsValue()))(
        _.originConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.PackageSummary.ReadOnly =
    zio.aws.codeartifact.model.PackageSummary.wrap(buildAwsValue())
}
object PackageSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.PackageSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.PackageSummary =
      zio.aws.codeartifact.model.PackageSummary(
        format.map(value => value),
        namespace.map(value => value),
        packageValue.map(value => value),
        originConfiguration.map(value => value.asEditable)
      )
    def format: Optional[zio.aws.codeartifact.model.PackageFormat]
    def namespace: Optional[PackageNamespace]
    def packageValue: Optional[PackageName]
    def originConfiguration: Optional[
      zio.aws.codeartifact.model.PackageOriginConfiguration.ReadOnly
    ]
    def getFormat
        : ZIO[Any, AwsError, zio.aws.codeartifact.model.PackageFormat] =
      AwsError.unwrapOptionField("format", format)
    def getNamespace: ZIO[Any, AwsError, PackageNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getPackageValue: ZIO[Any, AwsError, PackageName] =
      AwsError.unwrapOptionField("packageValue", packageValue)
    def getOriginConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codeartifact.model.PackageOriginConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("originConfiguration", originConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.PackageSummary
  ) extends zio.aws.codeartifact.model.PackageSummary.ReadOnly {
    override val format: Optional[zio.aws.codeartifact.model.PackageFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.format())
        .map(value => zio.aws.codeartifact.model.PackageFormat.wrap(value))
    override val namespace: Optional[PackageNamespace] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PackageNamespace(value)
      )
    override val packageValue: Optional[PackageName] = zio.aws.core.internal
      .optionalFromNullable(impl.packageValue())
      .map(value => zio.aws.codeartifact.model.primitives.PackageName(value))
    override val originConfiguration: Optional[
      zio.aws.codeartifact.model.PackageOriginConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.originConfiguration())
      .map(value =>
        zio.aws.codeartifact.model.PackageOriginConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.PackageSummary
  ): zio.aws.codeartifact.model.PackageSummary.ReadOnly = new Wrapper(impl)
}
