package zio.aws.codeartifact.model
import zio.aws.codeartifact.model.primitives.Timestamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GetAuthorizationTokenResponse(
    authorizationToken: Optional[String] = Optional.Absent,
    expiration: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.GetAuthorizationTokenResponse = {
    import GetAuthorizationTokenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.GetAuthorizationTokenResponse
      .builder()
      .optionallyWith(authorizationToken.map(value => value: java.lang.String))(
        _.authorizationToken
      )
      .optionallyWith(
        expiration.map(value => Timestamp.unwrap(value): Instant)
      )(_.expiration)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.GetAuthorizationTokenResponse.ReadOnly =
    zio.aws.codeartifact.model.GetAuthorizationTokenResponse
      .wrap(buildAwsValue())
}
object GetAuthorizationTokenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.GetAuthorizationTokenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.GetAuthorizationTokenResponse =
      zio.aws.codeartifact.model.GetAuthorizationTokenResponse(
        authorizationToken.map(value => value),
        expiration.map(value => value)
      )
    def authorizationToken: Optional[String]
    def expiration: Optional[Timestamp]
    def getAuthorizationToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("authorizationToken", authorizationToken)
    def getExpiration: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expiration", expiration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.GetAuthorizationTokenResponse
  ) extends zio.aws.codeartifact.model.GetAuthorizationTokenResponse.ReadOnly {
    override val authorizationToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.authorizationToken())
      .map(value => value: String)
    override val expiration: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expiration())
      .map(value => zio.aws.codeartifact.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.GetAuthorizationTokenResponse
  ): zio.aws.codeartifact.model.GetAuthorizationTokenResponse.ReadOnly =
    new Wrapper(impl)
}
