package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeartifact.model.primitives.{
  PackageVersionRevision,
  PackageVersion,
  AssetName
}
import scala.jdk.CollectionConverters.*
final case class GetPackageVersionAssetResponse(
    assetName: Optional[AssetName] = Optional.Absent,
    packageVersion: Optional[PackageVersion] = Optional.Absent,
    packageVersionRevision: Optional[PackageVersionRevision] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.GetPackageVersionAssetResponse = {
    import GetPackageVersionAssetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.GetPackageVersionAssetResponse
      .builder()
      .optionallyWith(
        assetName.map(value => AssetName.unwrap(value): java.lang.String)
      )(_.assetName)
      .optionallyWith(
        packageVersion.map(value =>
          PackageVersion.unwrap(value): java.lang.String
        )
      )(_.packageVersion)
      .optionallyWith(
        packageVersionRevision.map(value =>
          PackageVersionRevision.unwrap(value): java.lang.String
        )
      )(_.packageVersionRevision)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.GetPackageVersionAssetResponse.ReadOnly =
    zio.aws.codeartifact.model.GetPackageVersionAssetResponse
      .wrap(buildAwsValue())
}
object GetPackageVersionAssetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.GetPackageVersionAssetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.GetPackageVersionAssetResponse =
      zio.aws.codeartifact.model.GetPackageVersionAssetResponse(
        assetName.map(value => value),
        packageVersion.map(value => value),
        packageVersionRevision.map(value => value)
      )
    def assetName: Optional[AssetName]
    def packageVersion: Optional[PackageVersion]
    def packageVersionRevision: Optional[PackageVersionRevision]
    def getAssetName: ZIO[Any, AwsError, AssetName] =
      AwsError.unwrapOptionField("assetName", assetName)
    def getPackageVersion: ZIO[Any, AwsError, PackageVersion] =
      AwsError.unwrapOptionField("packageVersion", packageVersion)
    def getPackageVersionRevision: ZIO[Any, AwsError, PackageVersionRevision] =
      AwsError.unwrapOptionField(
        "packageVersionRevision",
        packageVersionRevision
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.GetPackageVersionAssetResponse
  ) extends zio.aws.codeartifact.model.GetPackageVersionAssetResponse.ReadOnly {
    override val assetName: Optional[AssetName] = zio.aws.core.internal
      .optionalFromNullable(impl.assetName())
      .map(value => zio.aws.codeartifact.model.primitives.AssetName(value))
    override val packageVersion: Optional[PackageVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packageVersion())
        .map(value =>
          zio.aws.codeartifact.model.primitives.PackageVersion(value)
        )
    override val packageVersionRevision: Optional[PackageVersionRevision] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packageVersionRevision())
        .map(value =>
          zio.aws.codeartifact.model.primitives.PackageVersionRevision(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.GetPackageVersionAssetResponse
  ): zio.aws.codeartifact.model.GetPackageVersionAssetResponse.ReadOnly =
    new Wrapper(impl)
}
