package zio.aws.codeartifact.model
import zio.aws.codeartifact.model.primitives.{
  AccountId,
  Timestamp,
  DomainName,
  Arn,
  Integer
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DomainDescription(
    name: Optional[DomainName] = Optional.Absent,
    owner: Optional[AccountId] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent,
    status: Optional[zio.aws.codeartifact.model.DomainStatus] = Optional.Absent,
    createdTime: Optional[Timestamp] = Optional.Absent,
    encryptionKey: Optional[Arn] = Optional.Absent,
    repositoryCount: Optional[Integer] = Optional.Absent,
    assetSizeBytes: Optional[Long] = Optional.Absent,
    s3BucketArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.DomainDescription = {
    import DomainDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.DomainDescription
      .builder()
      .optionallyWith(
        name.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        owner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        encryptionKey.map(value => Arn.unwrap(value): java.lang.String)
      )(_.encryptionKey)
      .optionallyWith(repositoryCount.map(value => value: java.lang.Integer))(
        _.repositoryCount
      )
      .optionallyWith(assetSizeBytes.map(value => value: java.lang.Long))(
        _.assetSizeBytes
      )
      .optionallyWith(
        s3BucketArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.s3BucketArn)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.DomainDescription.ReadOnly =
    zio.aws.codeartifact.model.DomainDescription.wrap(buildAwsValue())
}
object DomainDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.DomainDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.DomainDescription =
      zio.aws.codeartifact.model.DomainDescription(
        name.map(value => value),
        owner.map(value => value),
        arn.map(value => value),
        status.map(value => value),
        createdTime.map(value => value),
        encryptionKey.map(value => value),
        repositoryCount.map(value => value),
        assetSizeBytes.map(value => value),
        s3BucketArn.map(value => value)
      )
    def name: Optional[DomainName]
    def owner: Optional[AccountId]
    def arn: Optional[Arn]
    def status: Optional[zio.aws.codeartifact.model.DomainStatus]
    def createdTime: Optional[Timestamp]
    def encryptionKey: Optional[Arn]
    def repositoryCount: Optional[Integer]
    def assetSizeBytes: Optional[Long]
    def s3BucketArn: Optional[Arn]
    def getName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("name", name)
    def getOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("owner", owner)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getStatus: ZIO[Any, AwsError, zio.aws.codeartifact.model.DomainStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getEncryptionKey: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("encryptionKey", encryptionKey)
    def getRepositoryCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("repositoryCount", repositoryCount)
    def getAssetSizeBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("assetSizeBytes", assetSizeBytes)
    def getS3BucketArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("s3BucketArn", s3BucketArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.DomainDescription
  ) extends zio.aws.codeartifact.model.DomainDescription.ReadOnly {
    override val name: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.codeartifact.model.primitives.DomainName(value))
    override val owner: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.codeartifact.model.primitives.Arn(value))
    override val status: Optional[zio.aws.codeartifact.model.DomainStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.codeartifact.model.DomainStatus.wrap(value))
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.codeartifact.model.primitives.Timestamp(value))
    override val encryptionKey: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionKey())
      .map(value => zio.aws.codeartifact.model.primitives.Arn(value))
    override val repositoryCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.repositoryCount())
      .map(value => value: Integer)
    override val assetSizeBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.assetSizeBytes())
      .map(value => value: Long)
    override val s3BucketArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.s3BucketArn())
      .map(value => zio.aws.codeartifact.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.DomainDescription
  ): zio.aws.codeartifact.model.DomainDescription.ReadOnly = new Wrapper(impl)
}
