package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeartifact.model.primitives.{
  ExternalConnectionName,
  RepositoryName
}
import scala.jdk.CollectionConverters.*
final case class DomainEntryPoint(
    repositoryName: Optional[RepositoryName] = Optional.Absent,
    externalConnectionName: Optional[ExternalConnectionName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.DomainEntryPoint = {
    import DomainEntryPoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.DomainEntryPoint
      .builder()
      .optionallyWith(
        repositoryName.map(value =>
          RepositoryName.unwrap(value): java.lang.String
        )
      )(_.repositoryName)
      .optionallyWith(
        externalConnectionName.map(value =>
          ExternalConnectionName.unwrap(value): java.lang.String
        )
      )(_.externalConnectionName)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.DomainEntryPoint.ReadOnly =
    zio.aws.codeartifact.model.DomainEntryPoint.wrap(buildAwsValue())
}
object DomainEntryPoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.DomainEntryPoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.DomainEntryPoint =
      zio.aws.codeartifact.model.DomainEntryPoint(
        repositoryName.map(value => value),
        externalConnectionName.map(value => value)
      )
    def repositoryName: Optional[RepositoryName]
    def externalConnectionName: Optional[ExternalConnectionName]
    def getRepositoryName: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("repositoryName", repositoryName)
    def getExternalConnectionName: ZIO[Any, AwsError, ExternalConnectionName] =
      AwsError.unwrapOptionField(
        "externalConnectionName",
        externalConnectionName
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.DomainEntryPoint
  ) extends zio.aws.codeartifact.model.DomainEntryPoint.ReadOnly {
    override val repositoryName: Optional[RepositoryName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repositoryName())
        .map(value =>
          zio.aws.codeartifact.model.primitives.RepositoryName(value)
        )
    override val externalConnectionName: Optional[ExternalConnectionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalConnectionName())
        .map(value =>
          zio.aws.codeartifact.model.primitives.ExternalConnectionName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.DomainEntryPoint
  ): zio.aws.codeartifact.model.DomainEntryPoint.ReadOnly = new Wrapper(impl)
}
