package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PackageOriginConfiguration(
    restrictions: Optional[
      zio.aws.codeartifact.model.PackageOriginRestrictions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.PackageOriginConfiguration = {
    import PackageOriginConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.PackageOriginConfiguration
      .builder()
      .optionallyWith(restrictions.map(value => value.buildAwsValue()))(
        _.restrictions
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.PackageOriginConfiguration.ReadOnly =
    zio.aws.codeartifact.model.PackageOriginConfiguration.wrap(buildAwsValue())
}
object PackageOriginConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.PackageOriginConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.PackageOriginConfiguration =
      zio.aws.codeartifact.model
        .PackageOriginConfiguration(restrictions.map(value => value.asEditable))
    def restrictions: Optional[
      zio.aws.codeartifact.model.PackageOriginRestrictions.ReadOnly
    ]
    def getRestrictions: ZIO[
      Any,
      AwsError,
      zio.aws.codeartifact.model.PackageOriginRestrictions.ReadOnly
    ] = AwsError.unwrapOptionField("restrictions", restrictions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.PackageOriginConfiguration
  ) extends zio.aws.codeartifact.model.PackageOriginConfiguration.ReadOnly {
    override val restrictions: Optional[
      zio.aws.codeartifact.model.PackageOriginRestrictions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.restrictions())
      .map(value =>
        zio.aws.codeartifact.model.PackageOriginRestrictions.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.PackageOriginConfiguration
  ): zio.aws.codeartifact.model.PackageOriginConfiguration.ReadOnly =
    new Wrapper(impl)
}
