package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeartifact.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListPackagesResponse(
    packages: Optional[Iterable[zio.aws.codeartifact.model.PackageSummary]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.ListPackagesResponse = {
    import ListPackagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.ListPackagesResponse
      .builder()
      .optionallyWith(
        packages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.packages)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.ListPackagesResponse.ReadOnly =
    zio.aws.codeartifact.model.ListPackagesResponse.wrap(buildAwsValue())
}
object ListPackagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.ListPackagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.ListPackagesResponse =
      zio.aws.codeartifact.model.ListPackagesResponse(
        packages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def packages
        : Optional[List[zio.aws.codeartifact.model.PackageSummary.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getPackages: ZIO[Any, AwsError, List[
      zio.aws.codeartifact.model.PackageSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("packages", packages)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.ListPackagesResponse
  ) extends zio.aws.codeartifact.model.ListPackagesResponse.ReadOnly {
    override val packages
        : Optional[List[zio.aws.codeartifact.model.PackageSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codeartifact.model.PackageSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.ListPackagesResponse
  ): zio.aws.codeartifact.model.ListPackagesResponse.ReadOnly = new Wrapper(
    impl
  )
}
