package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PackageVersionOrigin(
    domainEntryPoint: Optional[zio.aws.codeartifact.model.DomainEntryPoint] =
      Optional.Absent,
    originType: Optional[zio.aws.codeartifact.model.PackageVersionOriginType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.PackageVersionOrigin = {
    import PackageVersionOrigin.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.PackageVersionOrigin
      .builder()
      .optionallyWith(domainEntryPoint.map(value => value.buildAwsValue()))(
        _.domainEntryPoint
      )
      .optionallyWith(originType.map(value => value.unwrap))(_.originType)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.PackageVersionOrigin.ReadOnly =
    zio.aws.codeartifact.model.PackageVersionOrigin.wrap(buildAwsValue())
}
object PackageVersionOrigin {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.PackageVersionOrigin
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.PackageVersionOrigin =
      zio.aws.codeartifact.model.PackageVersionOrigin(
        domainEntryPoint.map(value => value.asEditable),
        originType.map(value => value)
      )
    def domainEntryPoint
        : Optional[zio.aws.codeartifact.model.DomainEntryPoint.ReadOnly]
    def originType
        : Optional[zio.aws.codeartifact.model.PackageVersionOriginType]
    def getDomainEntryPoint: ZIO[
      Any,
      AwsError,
      zio.aws.codeartifact.model.DomainEntryPoint.ReadOnly
    ] = AwsError.unwrapOptionField("domainEntryPoint", domainEntryPoint)
    def getOriginType: ZIO[
      Any,
      AwsError,
      zio.aws.codeartifact.model.PackageVersionOriginType
    ] = AwsError.unwrapOptionField("originType", originType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.PackageVersionOrigin
  ) extends zio.aws.codeartifact.model.PackageVersionOrigin.ReadOnly {
    override val domainEntryPoint
        : Optional[zio.aws.codeartifact.model.DomainEntryPoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainEntryPoint())
        .map(value => zio.aws.codeartifact.model.DomainEntryPoint.wrap(value))
    override val originType
        : Optional[zio.aws.codeartifact.model.PackageVersionOriginType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originType())
        .map(value =>
          zio.aws.codeartifact.model.PackageVersionOriginType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.PackageVersionOrigin
  ): zio.aws.codeartifact.model.PackageVersionOrigin.ReadOnly = new Wrapper(
    impl
  )
}
