package zio.aws.codeartifact.model
import scala.jdk.CollectionConverters.*
sealed trait AllowUpstream {
  def unwrap: software.amazon.awssdk.services.codeartifact.model.AllowUpstream
}
object AllowUpstream {
  def wrap(
      value: software.amazon.awssdk.services.codeartifact.model.AllowUpstream
  ): zio.aws.codeartifact.model.AllowUpstream = value match {
    case software.amazon.awssdk.services.codeartifact.model.AllowUpstream.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codeartifact.model.AllowUpstream.ALLOW =>
      val r = ALLOW
      r
    case software.amazon.awssdk.services.codeartifact.model.AllowUpstream.BLOCK =>
      val r = BLOCK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codeartifact.model.AllowUpstream {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.AllowUpstream =
      software.amazon.awssdk.services.codeartifact.model.AllowUpstream.UNKNOWN_TO_SDK_VERSION
  }
  case object ALLOW extends zio.aws.codeartifact.model.AllowUpstream {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.AllowUpstream =
      software.amazon.awssdk.services.codeartifact.model.AllowUpstream.ALLOW
  }
  case object BLOCK extends zio.aws.codeartifact.model.AllowUpstream {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.AllowUpstream =
      software.amazon.awssdk.services.codeartifact.model.AllowUpstream.BLOCK
  }
}
