package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeartifact.model.primitives.{AccountId, DomainName}
import scala.jdk.CollectionConverters.*
final case class DescribeDomainRequest(
    domain: DomainName,
    domainOwner: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.DescribeDomainRequest = {
    import DescribeDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.DescribeDomainRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.DescribeDomainRequest.ReadOnly =
    zio.aws.codeartifact.model.DescribeDomainRequest.wrap(buildAwsValue())
}
object DescribeDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.DescribeDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.DescribeDomainRequest =
      zio.aws.codeartifact.model
        .DescribeDomainRequest(domain, domainOwner.map(value => value))
    def domain: DomainName
    def domainOwner: Optional[AccountId]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.DescribeDomainRequest
  ) extends zio.aws.codeartifact.model.DescribeDomainRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.codeartifact.model.primitives.DomainName(impl.domain())
    override val domainOwner: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.DescribeDomainRequest
  ): zio.aws.codeartifact.model.DescribeDomainRequest.ReadOnly = new Wrapper(
    impl
  )
}
