package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeartifact.model.primitives.{
  PackageVersionRevision,
  PackageVersion,
  PackageName,
  PackageNamespace
}
import scala.jdk.CollectionConverters.*
final case class GetPackageVersionReadmeResponse(
    format: Optional[zio.aws.codeartifact.model.PackageFormat] =
      Optional.Absent,
    namespace: Optional[PackageNamespace] = Optional.Absent,
    packageValue: Optional[PackageName] = Optional.Absent,
    version: Optional[PackageVersion] = Optional.Absent,
    versionRevision: Optional[PackageVersionRevision] = Optional.Absent,
    readme: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.GetPackageVersionReadmeResponse = {
    import GetPackageVersionReadmeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.GetPackageVersionReadmeResponse
      .builder()
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(
        namespace.map(value => PackageNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        packageValue.map(value => PackageName.unwrap(value): java.lang.String)
      )(_.packageValue)
      .optionallyWith(
        version.map(value => PackageVersion.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        versionRevision.map(value =>
          PackageVersionRevision.unwrap(value): java.lang.String
        )
      )(_.versionRevision)
      .optionallyWith(readme.map(value => value: java.lang.String))(_.readme)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.GetPackageVersionReadmeResponse.ReadOnly =
    zio.aws.codeartifact.model.GetPackageVersionReadmeResponse
      .wrap(buildAwsValue())
}
object GetPackageVersionReadmeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.GetPackageVersionReadmeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.GetPackageVersionReadmeResponse =
      zio.aws.codeartifact.model.GetPackageVersionReadmeResponse(
        format.map(value => value),
        namespace.map(value => value),
        packageValue.map(value => value),
        version.map(value => value),
        versionRevision.map(value => value),
        readme.map(value => value)
      )
    def format: Optional[zio.aws.codeartifact.model.PackageFormat]
    def namespace: Optional[PackageNamespace]
    def packageValue: Optional[PackageName]
    def version: Optional[PackageVersion]
    def versionRevision: Optional[PackageVersionRevision]
    def readme: Optional[String]
    def getFormat
        : ZIO[Any, AwsError, zio.aws.codeartifact.model.PackageFormat] =
      AwsError.unwrapOptionField("format", format)
    def getNamespace: ZIO[Any, AwsError, PackageNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getPackageValue: ZIO[Any, AwsError, PackageName] =
      AwsError.unwrapOptionField("packageValue", packageValue)
    def getVersion: ZIO[Any, AwsError, PackageVersion] =
      AwsError.unwrapOptionField("version", version)
    def getVersionRevision: ZIO[Any, AwsError, PackageVersionRevision] =
      AwsError.unwrapOptionField("versionRevision", versionRevision)
    def getReadme: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("readme", readme)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.GetPackageVersionReadmeResponse
  ) extends zio.aws.codeartifact.model.GetPackageVersionReadmeResponse.ReadOnly {
    override val format: Optional[zio.aws.codeartifact.model.PackageFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.format())
        .map(value => zio.aws.codeartifact.model.PackageFormat.wrap(value))
    override val namespace: Optional[PackageNamespace] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PackageNamespace(value)
      )
    override val packageValue: Optional[PackageName] = zio.aws.core.internal
      .optionalFromNullable(impl.packageValue())
      .map(value => zio.aws.codeartifact.model.primitives.PackageName(value))
    override val version: Optional[PackageVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.codeartifact.model.primitives.PackageVersion(value))
    override val versionRevision: Optional[PackageVersionRevision] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionRevision())
        .map(value =>
          zio.aws.codeartifact.model.primitives.PackageVersionRevision(value)
        )
    override val readme: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.readme())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.GetPackageVersionReadmeResponse
  ): zio.aws.codeartifact.model.GetPackageVersionReadmeResponse.ReadOnly =
    new Wrapper(impl)
}
