package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeartifact.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListRepositoriesResponse(
    repositories: Optional[
      Iterable[zio.aws.codeartifact.model.RepositorySummary]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.ListRepositoriesResponse = {
    import ListRepositoriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.ListRepositoriesResponse
      .builder()
      .optionallyWith(
        repositories.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.repositories)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.ListRepositoriesResponse.ReadOnly =
    zio.aws.codeartifact.model.ListRepositoriesResponse.wrap(buildAwsValue())
}
object ListRepositoriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.ListRepositoriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.ListRepositoriesResponse =
      zio.aws.codeartifact.model.ListRepositoriesResponse(
        repositories.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def repositories
        : Optional[List[zio.aws.codeartifact.model.RepositorySummary.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getRepositories: ZIO[Any, AwsError, List[
      zio.aws.codeartifact.model.RepositorySummary.ReadOnly
    ]] = AwsError.unwrapOptionField("repositories", repositories)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.ListRepositoriesResponse
  ) extends zio.aws.codeartifact.model.ListRepositoriesResponse.ReadOnly {
    override val repositories: Optional[
      List[zio.aws.codeartifact.model.RepositorySummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.repositories())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codeartifact.model.RepositorySummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.ListRepositoriesResponse
  ): zio.aws.codeartifact.model.ListRepositoriesResponse.ReadOnly = new Wrapper(
    impl
  )
}
