package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeartifact.model.primitives.{
  Description,
  RepositoryName,
  AccountId,
  DomainName
}
import scala.jdk.CollectionConverters.*
final case class CreateRepositoryRequest(
    domain: DomainName,
    domainOwner: Optional[AccountId] = Optional.Absent,
    repository: RepositoryName,
    description: Optional[Description] = Optional.Absent,
    upstreams: Optional[
      Iterable[zio.aws.codeartifact.model.UpstreamRepository]
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.codeartifact.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.CreateRepositoryRequest = {
    import CreateRepositoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.CreateRepositoryRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .repository(RepositoryName.unwrap(repository): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        upstreams.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.upstreams)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.CreateRepositoryRequest.ReadOnly =
    zio.aws.codeartifact.model.CreateRepositoryRequest.wrap(buildAwsValue())
}
object CreateRepositoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.CreateRepositoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.CreateRepositoryRequest =
      zio.aws.codeartifact.model.CreateRepositoryRequest(
        domain,
        domainOwner.map(value => value),
        repository,
        description.map(value => value),
        upstreams.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def domain: DomainName
    def domainOwner: Optional[AccountId]
    def repository: RepositoryName
    def description: Optional[Description]
    def upstreams
        : Optional[List[zio.aws.codeartifact.model.UpstreamRepository.ReadOnly]]
    def tags: Optional[List[zio.aws.codeartifact.model.Tag.ReadOnly]]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
    def getRepository: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repository)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getUpstreams: ZIO[Any, AwsError, List[
      zio.aws.codeartifact.model.UpstreamRepository.ReadOnly
    ]] = AwsError.unwrapOptionField("upstreams", upstreams)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.codeartifact.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.CreateRepositoryRequest
  ) extends zio.aws.codeartifact.model.CreateRepositoryRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.codeartifact.model.primitives.DomainName(impl.domain())
    override val domainOwner: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val repository: RepositoryName =
      zio.aws.codeartifact.model.primitives.RepositoryName(impl.repository())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.codeartifact.model.primitives.Description(value))
    override val upstreams: Optional[
      List[zio.aws.codeartifact.model.UpstreamRepository.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.upstreams())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codeartifact.model.UpstreamRepository.wrap(item)
        }.toList
      )
    override val tags: Optional[List[zio.aws.codeartifact.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codeartifact.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.CreateRepositoryRequest
  ): zio.aws.codeartifact.model.CreateRepositoryRequest.ReadOnly = new Wrapper(
    impl
  )
}
