package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteDomainPermissionsPolicyResponse(
    policy: Optional[zio.aws.codeartifact.model.ResourcePolicy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.DeleteDomainPermissionsPolicyResponse = {
    import DeleteDomainPermissionsPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.DeleteDomainPermissionsPolicyResponse
      .builder()
      .optionallyWith(policy.map(value => value.buildAwsValue()))(_.policy)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.DeleteDomainPermissionsPolicyResponse.ReadOnly =
    zio.aws.codeartifact.model.DeleteDomainPermissionsPolicyResponse
      .wrap(buildAwsValue())
}
object DeleteDomainPermissionsPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.DeleteDomainPermissionsPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeartifact.model.DeleteDomainPermissionsPolicyResponse =
      zio.aws.codeartifact.model.DeleteDomainPermissionsPolicyResponse(
        policy.map(value => value.asEditable)
      )
    def policy: Optional[zio.aws.codeartifact.model.ResourcePolicy.ReadOnly]
    def getPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.codeartifact.model.ResourcePolicy.ReadOnly
    ] = AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.DeleteDomainPermissionsPolicyResponse
  ) extends zio.aws.codeartifact.model.DeleteDomainPermissionsPolicyResponse.ReadOnly {
    override val policy
        : Optional[zio.aws.codeartifact.model.ResourcePolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policy())
        .map(value => zio.aws.codeartifact.model.ResourcePolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.DeleteDomainPermissionsPolicyResponse
  ): zio.aws.codeartifact.model.DeleteDomainPermissionsPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
