package zio.aws.codeartifact.model
import scala.jdk.CollectionConverters.*
sealed trait HashAlgorithm {
  def unwrap: software.amazon.awssdk.services.codeartifact.model.HashAlgorithm
}
object HashAlgorithm {
  def wrap(
      value: software.amazon.awssdk.services.codeartifact.model.HashAlgorithm
  ): zio.aws.codeartifact.model.HashAlgorithm = value match {
    case software.amazon.awssdk.services.codeartifact.model.HashAlgorithm.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codeartifact.model.HashAlgorithm.MD5 =>
      val r = MD5
      r
    case software.amazon.awssdk.services.codeartifact.model.HashAlgorithm.SHA_1 =>
      val r = `SHA-1`
      r
    case software.amazon.awssdk.services.codeartifact.model.HashAlgorithm.SHA_256 =>
      val r = `SHA-256`
      r
    case software.amazon.awssdk.services.codeartifact.model.HashAlgorithm.SHA_512 =>
      val r = `SHA-512`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codeartifact.model.HashAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.HashAlgorithm =
      software.amazon.awssdk.services.codeartifact.model.HashAlgorithm.UNKNOWN_TO_SDK_VERSION
  }
  case object MD5 extends zio.aws.codeartifact.model.HashAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.HashAlgorithm =
      software.amazon.awssdk.services.codeartifact.model.HashAlgorithm.MD5
  }
  case object `SHA-1` extends zio.aws.codeartifact.model.HashAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.HashAlgorithm =
      software.amazon.awssdk.services.codeartifact.model.HashAlgorithm.SHA_1
  }
  case object `SHA-256` extends zio.aws.codeartifact.model.HashAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.HashAlgorithm =
      software.amazon.awssdk.services.codeartifact.model.HashAlgorithm.SHA_256
  }
  case object `SHA-512` extends zio.aws.codeartifact.model.HashAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.HashAlgorithm =
      software.amazon.awssdk.services.codeartifact.model.HashAlgorithm.SHA_512
  }
}
