package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeartifact.model.primitives.{PackageName, PackageNamespace}
import scala.jdk.CollectionConverters.*
final case class PackageDependency(
    namespace: Optional[PackageNamespace] = Optional.Absent,
    packageValue: Optional[PackageName] = Optional.Absent,
    dependencyType: Optional[String] = Optional.Absent,
    versionRequirement: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.PackageDependency = {
    import PackageDependency.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.PackageDependency
      .builder()
      .optionallyWith(
        namespace.map(value => PackageNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        packageValue.map(value => PackageName.unwrap(value): java.lang.String)
      )(_.packageValue)
      .optionallyWith(dependencyType.map(value => value: java.lang.String))(
        _.dependencyType
      )
      .optionallyWith(versionRequirement.map(value => value: java.lang.String))(
        _.versionRequirement
      )
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.PackageDependency.ReadOnly =
    zio.aws.codeartifact.model.PackageDependency.wrap(buildAwsValue())
}
object PackageDependency {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.PackageDependency
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.PackageDependency =
      zio.aws.codeartifact.model.PackageDependency(
        namespace.map(value => value),
        packageValue.map(value => value),
        dependencyType.map(value => value),
        versionRequirement.map(value => value)
      )
    def namespace: Optional[PackageNamespace]
    def packageValue: Optional[PackageName]
    def dependencyType: Optional[String]
    def versionRequirement: Optional[String]
    def getNamespace: ZIO[Any, AwsError, PackageNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getPackageValue: ZIO[Any, AwsError, PackageName] =
      AwsError.unwrapOptionField("packageValue", packageValue)
    def getDependencyType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dependencyType", dependencyType)
    def getVersionRequirement: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("versionRequirement", versionRequirement)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.PackageDependency
  ) extends zio.aws.codeartifact.model.PackageDependency.ReadOnly {
    override val namespace: Optional[PackageNamespace] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PackageNamespace(value)
      )
    override val packageValue: Optional[PackageName] = zio.aws.core.internal
      .optionalFromNullable(impl.packageValue())
      .map(value => zio.aws.codeartifact.model.primitives.PackageName(value))
    override val dependencyType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dependencyType())
      .map(value => value: String)
    override val versionRequirement: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.versionRequirement())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.PackageDependency
  ): zio.aws.codeartifact.model.PackageDependency.ReadOnly = new Wrapper(impl)
}
