package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeartifact.model.primitives.{
  HashValue,
  LongOptional,
  AssetName
}
import scala.jdk.CollectionConverters.*
final case class AssetSummary(
    name: AssetName,
    size: Optional[LongOptional] = Optional.Absent,
    hashes: Optional[Map[zio.aws.codeartifact.model.HashAlgorithm, HashValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.AssetSummary = {
    import AssetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.AssetSummary
      .builder()
      .name(AssetName.unwrap(name): java.lang.String)
      .optionallyWith(size.map(value => value: java.lang.Long))(_.size)
      .optionallyWith(
        hashes.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (HashValue.unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.hashesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.AssetSummary.ReadOnly =
    zio.aws.codeartifact.model.AssetSummary.wrap(buildAwsValue())
}
object AssetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.AssetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.AssetSummary =
      zio.aws.codeartifact.model.AssetSummary(
        name,
        size.map(value => value),
        hashes.map(value => value)
      )
    def name: AssetName
    def size: Optional[LongOptional]
    def hashes
        : Optional[Map[zio.aws.codeartifact.model.HashAlgorithm, HashValue]]
    def getName: ZIO[Any, Nothing, AssetName] = ZIO.succeed(name)
    def getSize: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("size", size)
    def getHashes: ZIO[Any, AwsError, Map[
      zio.aws.codeartifact.model.HashAlgorithm,
      HashValue
    ]] = AwsError.unwrapOptionField("hashes", hashes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.AssetSummary
  ) extends zio.aws.codeartifact.model.AssetSummary.ReadOnly {
    override val name: AssetName =
      zio.aws.codeartifact.model.primitives.AssetName(impl.name())
    override val size: Optional[LongOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.size())
      .map(value => value: LongOptional)
    override val hashes
        : Optional[Map[zio.aws.codeartifact.model.HashAlgorithm, HashValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hashes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.codeartifact.model.HashAlgorithm.wrap(
                key
              ) -> zio.aws.codeartifact.model.primitives.HashValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.AssetSummary
  ): zio.aws.codeartifact.model.AssetSummary.ReadOnly = new Wrapper(impl)
}
