package zio.aws.codeartifact
import zio.aws.codeartifact.model.primitives.PackageVersionRevision.Type
import zio.aws.codeartifact.model.primitives.{
  TagKey,
  PackageVersionRevision,
  PackageVersion,
  HashValue
}
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AccountId extends Subtype[String]
    type AccountId = zio.aws.codeartifact.model.primitives.AccountId.Type
    object Arn extends Subtype[String]
    type Arn = zio.aws.codeartifact.model.primitives.Arn.Type
    object Asset extends Subtype[Chunk[Byte]]
    type Asset = zio.aws.codeartifact.model.primitives.Asset.Type
    object AssetName extends Subtype[String]
    type AssetName = zio.aws.codeartifact.model.primitives.AssetName.Type
    object AuthorizationTokenDurationSeconds extends Subtype[Long]
    type AuthorizationTokenDurationSeconds =
      zio.aws.codeartifact.model.primitives.AuthorizationTokenDurationSeconds.Type
    type BooleanOptional = Boolean
    object Description extends Subtype[String]
    type Description = zio.aws.codeartifact.model.primitives.Description.Type
    object DomainName extends Subtype[String]
    type DomainName = zio.aws.codeartifact.model.primitives.DomainName.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.codeartifact.model.primitives.ErrorMessage.Type
    object ExternalConnectionName extends Subtype[String]
    type ExternalConnectionName =
      zio.aws.codeartifact.model.primitives.ExternalConnectionName.Type
    object HashValue extends Subtype[String]
    type HashValue = zio.aws.codeartifact.model.primitives.HashValue.Type
    type Integer = Int
    object ListDomainsMaxResults extends Subtype[Int]
    type ListDomainsMaxResults =
      zio.aws.codeartifact.model.primitives.ListDomainsMaxResults.Type
    object ListPackageVersionAssetsMaxResults extends Subtype[Int]
    type ListPackageVersionAssetsMaxResults =
      zio.aws.codeartifact.model.primitives.ListPackageVersionAssetsMaxResults.Type
    object ListPackageVersionsMaxResults extends Subtype[Int]
    type ListPackageVersionsMaxResults =
      zio.aws.codeartifact.model.primitives.ListPackageVersionsMaxResults.Type
    object ListPackagesMaxResults extends Subtype[Int]
    type ListPackagesMaxResults =
      zio.aws.codeartifact.model.primitives.ListPackagesMaxResults.Type
    object ListRepositoriesInDomainMaxResults extends Subtype[Int]
    type ListRepositoriesInDomainMaxResults =
      zio.aws.codeartifact.model.primitives.ListRepositoriesInDomainMaxResults.Type
    object ListRepositoriesMaxResults extends Subtype[Int]
    type ListRepositoriesMaxResults =
      zio.aws.codeartifact.model.primitives.ListRepositoriesMaxResults.Type
    type LongOptional = Long
    object PackageName extends Subtype[String]
    type PackageName = zio.aws.codeartifact.model.primitives.PackageName.Type
    object PackageNamespace extends Subtype[String]
    type PackageNamespace =
      zio.aws.codeartifact.model.primitives.PackageNamespace.Type
    object PackageVersion extends Subtype[String]
    type PackageVersion =
      zio.aws.codeartifact.model.primitives.PackageVersion.Type
    object PackageVersionRevision extends Subtype[String]
    type PackageVersionRevision =
      zio.aws.codeartifact.model.primitives.PackageVersionRevision.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.codeartifact.model.primitives.PaginationToken.Type
    object PolicyDocument extends Subtype[String]
    type PolicyDocument =
      zio.aws.codeartifact.model.primitives.PolicyDocument.Type
    object PolicyRevision extends Subtype[String]
    type PolicyRevision =
      zio.aws.codeartifact.model.primitives.PolicyRevision.Type
    object RepositoryName extends Subtype[String]
    type RepositoryName =
      zio.aws.codeartifact.model.primitives.RepositoryName.Type
    object String255 extends Subtype[String]
    type String255 = zio.aws.codeartifact.model.primitives.String255.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.codeartifact.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.codeartifact.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.codeartifact.model.primitives.Timestamp.Type
  }
  type AssetHashes = Map[zio.aws.codeartifact.model.HashAlgorithm, HashValue]
  type AssetSummaryList = List[zio.aws.codeartifact.model.AssetSummary]
  type DomainSummaryList = List[zio.aws.codeartifact.model.DomainSummary]
  type LicenseInfoList = List[zio.aws.codeartifact.model.LicenseInfo]
  type PackageDependencyList =
    List[zio.aws.codeartifact.model.PackageDependency]
  type PackageSummaryList = List[zio.aws.codeartifact.model.PackageSummary]
  type PackageVersionErrorMap =
    Map[PackageVersion, zio.aws.codeartifact.model.PackageVersionError]
  type PackageVersionList = List[PackageVersion]
  type PackageVersionRevisionMap = Map[PackageVersion, PackageVersionRevision]
  type PackageVersionSummaryList =
    List[zio.aws.codeartifact.model.PackageVersionSummary]
  type RepositoryExternalConnectionInfoList =
    List[zio.aws.codeartifact.model.RepositoryExternalConnectionInfo]
  type RepositorySummaryList =
    List[zio.aws.codeartifact.model.RepositorySummary]
  type SuccessfulPackageVersionInfoMap =
    Map[PackageVersion, zio.aws.codeartifact.model.SuccessfulPackageVersionInfo]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.codeartifact.model.Tag]
  type UpstreamRepositoryInfoList =
    List[zio.aws.codeartifact.model.UpstreamRepositoryInfo]
  type UpstreamRepositoryList =
    List[zio.aws.codeartifact.model.UpstreamRepository]
}
