package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeartifact.model.primitives.{
  RepositoryName,
  AccountId,
  DomainName
}
import scala.jdk.CollectionConverters.*
final case class DeleteRepositoryRequest(
    domain: DomainName,
    domainOwner: Optional[AccountId] = Optional.Absent,
    repository: RepositoryName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryRequest = {
    import DeleteRepositoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .repository(RepositoryName.unwrap(repository): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.DeleteRepositoryRequest.ReadOnly =
    zio.aws.codeartifact.model.DeleteRepositoryRequest.wrap(buildAwsValue())
}
object DeleteRepositoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.DeleteRepositoryRequest =
      zio.aws.codeartifact.model.DeleteRepositoryRequest(
        domain,
        domainOwner.map(value => value),
        repository
      )
    def domain: DomainName
    def domainOwner: Optional[AccountId]
    def repository: RepositoryName
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
    def getRepository: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repository)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryRequest
  ) extends zio.aws.codeartifact.model.DeleteRepositoryRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.codeartifact.model.primitives.DomainName(impl.domain())
    override val domainOwner: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val repository: RepositoryName =
      zio.aws.codeartifact.model.primitives.RepositoryName(impl.repository())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryRequest
  ): zio.aws.codeartifact.model.DeleteRepositoryRequest.ReadOnly = new Wrapper(
    impl
  )
}
