package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutDomainPermissionsPolicyResponse(
    policy: Optional[zio.aws.codeartifact.model.ResourcePolicy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.PutDomainPermissionsPolicyResponse = {
    import PutDomainPermissionsPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.PutDomainPermissionsPolicyResponse
      .builder()
      .optionallyWith(policy.map(value => value.buildAwsValue()))(_.policy)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.PutDomainPermissionsPolicyResponse.ReadOnly =
    zio.aws.codeartifact.model.PutDomainPermissionsPolicyResponse
      .wrap(buildAwsValue())
}
object PutDomainPermissionsPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.PutDomainPermissionsPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeartifact.model.PutDomainPermissionsPolicyResponse =
      zio.aws.codeartifact.model.PutDomainPermissionsPolicyResponse(
        policy.map(value => value.asEditable)
      )
    def policy: Optional[zio.aws.codeartifact.model.ResourcePolicy.ReadOnly]
    def getPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.codeartifact.model.ResourcePolicy.ReadOnly
    ] = AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.PutDomainPermissionsPolicyResponse
  ) extends zio.aws.codeartifact.model.PutDomainPermissionsPolicyResponse.ReadOnly {
    override val policy
        : Optional[zio.aws.codeartifact.model.ResourcePolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policy())
        .map(value => zio.aws.codeartifact.model.ResourcePolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.PutDomainPermissionsPolicyResponse
  ): zio.aws.codeartifact.model.PutDomainPermissionsPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
