package zio.aws.codeartifact.model
import scala.jdk.CollectionConverters.*
sealed trait PackageVersionErrorCode {
  def unwrap: software.amazon.awssdk.services.codeartifact.model.PackageVersionErrorCode
}
object PackageVersionErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.codeartifact.model.PackageVersionErrorCode
  ): zio.aws.codeartifact.model.PackageVersionErrorCode = value match {
    case software.amazon.awssdk.services.codeartifact.model.PackageVersionErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codeartifact.model.PackageVersionErrorCode.ALREADY_EXISTS =>
      val r = ALREADY_EXISTS
      r
    case software.amazon.awssdk.services.codeartifact.model.PackageVersionErrorCode.MISMATCHED_REVISION =>
      val r = MISMATCHED_REVISION
      r
    case software.amazon.awssdk.services.codeartifact.model.PackageVersionErrorCode.MISMATCHED_STATUS =>
      val r = MISMATCHED_STATUS
      r
    case software.amazon.awssdk.services.codeartifact.model.PackageVersionErrorCode.NOT_ALLOWED =>
      val r = NOT_ALLOWED
      r
    case software.amazon.awssdk.services.codeartifact.model.PackageVersionErrorCode.NOT_FOUND =>
      val r = NOT_FOUND
      r
    case software.amazon.awssdk.services.codeartifact.model.PackageVersionErrorCode.SKIPPED =>
      val r = SKIPPED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codeartifact.model.PackageVersionErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.PackageVersionErrorCode =
      software.amazon.awssdk.services.codeartifact.model.PackageVersionErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object ALREADY_EXISTS
      extends zio.aws.codeartifact.model.PackageVersionErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.PackageVersionErrorCode =
      software.amazon.awssdk.services.codeartifact.model.PackageVersionErrorCode.ALREADY_EXISTS
  }
  case object MISMATCHED_REVISION
      extends zio.aws.codeartifact.model.PackageVersionErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.PackageVersionErrorCode =
      software.amazon.awssdk.services.codeartifact.model.PackageVersionErrorCode.MISMATCHED_REVISION
  }
  case object MISMATCHED_STATUS
      extends zio.aws.codeartifact.model.PackageVersionErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.PackageVersionErrorCode =
      software.amazon.awssdk.services.codeartifact.model.PackageVersionErrorCode.MISMATCHED_STATUS
  }
  case object NOT_ALLOWED
      extends zio.aws.codeartifact.model.PackageVersionErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.PackageVersionErrorCode =
      software.amazon.awssdk.services.codeartifact.model.PackageVersionErrorCode.NOT_ALLOWED
  }
  case object NOT_FOUND
      extends zio.aws.codeartifact.model.PackageVersionErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.PackageVersionErrorCode =
      software.amazon.awssdk.services.codeartifact.model.PackageVersionErrorCode.NOT_FOUND
  }
  case object SKIPPED
      extends zio.aws.codeartifact.model.PackageVersionErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codeartifact.model.PackageVersionErrorCode =
      software.amazon.awssdk.services.codeartifact.model.PackageVersionErrorCode.SKIPPED
  }
}
