package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.ErrorMessage
import scala.jdk.CollectionConverters.*
final case class PackageVersionError(
    errorCode: Option[zio.aws.codeartifact.model.PackageVersionErrorCode] =
      None,
    errorMessage: Option[ErrorMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.PackageVersionError = {
    import PackageVersionError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.PackageVersionError
      .builder()
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.PackageVersionError.ReadOnly =
    zio.aws.codeartifact.model.PackageVersionError.wrap(buildAwsValue())
}
object PackageVersionError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.PackageVersionError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.PackageVersionError =
      zio.aws.codeartifact.model.PackageVersionError(
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def errorCode: Option[zio.aws.codeartifact.model.PackageVersionErrorCode]
    def errorMessage: Option[ErrorMessage]
    def getErrorCode: ZIO[
      Any,
      AwsError,
      zio.aws.codeartifact.model.PackageVersionErrorCode
    ] = AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.PackageVersionError
  ) extends zio.aws.codeartifact.model.PackageVersionError.ReadOnly {
    override val errorCode
        : Option[zio.aws.codeartifact.model.PackageVersionErrorCode] = scala
      .Option(impl.errorCode())
      .map(value =>
        zio.aws.codeartifact.model.PackageVersionErrorCode.wrap(value)
      )
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.codeartifact.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.PackageVersionError
  ): zio.aws.codeartifact.model.PackageVersionError.ReadOnly = new Wrapper(impl)
}
