package zio.aws.codeartifact.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.{
  PackageName,
  AccountId,
  DomainName,
  RepositoryName,
  PackageVersion,
  PaginationToken,
  PackageNamespace,
  ListPackageVersionAssetsMaxResults
}
import scala.jdk.CollectionConverters.*
final case class ListPackageVersionAssetsRequest(
    domain: DomainName,
    domainOwner: Option[AccountId] = None,
    repository: RepositoryName,
    format: zio.aws.codeartifact.model.PackageFormat,
    namespace: Option[PackageNamespace] = None,
    packageValue: PackageName,
    packageVersion: PackageVersion,
    maxResults: Option[ListPackageVersionAssetsMaxResults] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.ListPackageVersionAssetsRequest = {
    import ListPackageVersionAssetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.ListPackageVersionAssetsRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .repository(RepositoryName.unwrap(repository): java.lang.String)
      .format(format.unwrap)
      .optionallyWith(
        namespace.map(value => PackageNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .packageValue(PackageName.unwrap(packageValue): java.lang.String)
      .packageVersion(PackageVersion.unwrap(packageVersion): java.lang.String)
      .optionallyWith(
        maxResults.map(value =>
          ListPackageVersionAssetsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.ListPackageVersionAssetsRequest.ReadOnly =
    zio.aws.codeartifact.model.ListPackageVersionAssetsRequest
      .wrap(buildAwsValue())
}
object ListPackageVersionAssetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.ListPackageVersionAssetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.ListPackageVersionAssetsRequest =
      zio.aws.codeartifact.model.ListPackageVersionAssetsRequest(
        domain,
        domainOwner.map(value => value),
        repository,
        format,
        namespace.map(value => value),
        packageValue,
        packageVersion,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def domain: DomainName
    def domainOwner: Option[AccountId]
    def repository: RepositoryName
    def format: zio.aws.codeartifact.model.PackageFormat
    def namespace: Option[PackageNamespace]
    def packageValue: PackageName
    def packageVersion: PackageVersion
    def maxResults: Option[ListPackageVersionAssetsMaxResults]
    def nextToken: Option[PaginationToken]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
    def getRepository: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repository)
    def getFormat: ZIO[Any, Nothing, zio.aws.codeartifact.model.PackageFormat] =
      ZIO.succeed(format)
    def getNamespace: ZIO[Any, AwsError, PackageNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getPackageValue: ZIO[Any, Nothing, PackageName] =
      ZIO.succeed(packageValue)
    def getPackageVersion: ZIO[Any, Nothing, PackageVersion] =
      ZIO.succeed(packageVersion)
    def getMaxResults: ZIO[Any, AwsError, ListPackageVersionAssetsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.ListPackageVersionAssetsRequest
  ) extends zio.aws.codeartifact.model.ListPackageVersionAssetsRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.codeartifact.model.primitives.DomainName(impl.domain())
    override val domainOwner: Option[AccountId] = scala
      .Option(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val repository: RepositoryName =
      zio.aws.codeartifact.model.primitives.RepositoryName(impl.repository())
    override val format: zio.aws.codeartifact.model.PackageFormat =
      zio.aws.codeartifact.model.PackageFormat.wrap(impl.format())
    override val namespace: Option[PackageNamespace] = scala
      .Option(impl.namespace())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PackageNamespace(value)
      )
    override val packageValue: PackageName =
      zio.aws.codeartifact.model.primitives.PackageName(impl.packageValue())
    override val packageVersion: PackageVersion =
      zio.aws.codeartifact.model.primitives
        .PackageVersion(impl.packageVersion())
    override val maxResults: Option[ListPackageVersionAssetsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.codeartifact.model.primitives
          .ListPackageVersionAssetsMaxResults(value)
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.ListPackageVersionAssetsRequest
  ): zio.aws.codeartifact.model.ListPackageVersionAssetsRequest.ReadOnly =
    new Wrapper(impl)
}
