package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.{
  RepositoryName,
  AccountId,
  DomainName
}
import scala.jdk.CollectionConverters.*
final case class GetRepositoryEndpointRequest(
    domain: DomainName,
    domainOwner: Option[AccountId] = None,
    repository: RepositoryName,
    format: zio.aws.codeartifact.model.PackageFormat
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.GetRepositoryEndpointRequest = {
    import GetRepositoryEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.GetRepositoryEndpointRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .repository(RepositoryName.unwrap(repository): java.lang.String)
      .format(format.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.GetRepositoryEndpointRequest.ReadOnly =
    zio.aws.codeartifact.model.GetRepositoryEndpointRequest
      .wrap(buildAwsValue())
}
object GetRepositoryEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.GetRepositoryEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.GetRepositoryEndpointRequest =
      zio.aws.codeartifact.model.GetRepositoryEndpointRequest(
        domain,
        domainOwner.map(value => value),
        repository,
        format
      )
    def domain: DomainName
    def domainOwner: Option[AccountId]
    def repository: RepositoryName
    def format: zio.aws.codeartifact.model.PackageFormat
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
    def getRepository: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repository)
    def getFormat: ZIO[Any, Nothing, zio.aws.codeartifact.model.PackageFormat] =
      ZIO.succeed(format)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.GetRepositoryEndpointRequest
  ) extends zio.aws.codeartifact.model.GetRepositoryEndpointRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.codeartifact.model.primitives.DomainName(impl.domain())
    override val domainOwner: Option[AccountId] = scala
      .Option(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val repository: RepositoryName =
      zio.aws.codeartifact.model.primitives.RepositoryName(impl.repository())
    override val format: zio.aws.codeartifact.model.PackageFormat =
      zio.aws.codeartifact.model.PackageFormat.wrap(impl.format())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.GetRepositoryEndpointRequest
  ): zio.aws.codeartifact.model.GetRepositoryEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
