package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.{
  PackageName,
  AssetName,
  AccountId,
  DomainName,
  RepositoryName,
  PackageVersion,
  PackageNamespace,
  PackageVersionRevision
}
import scala.jdk.CollectionConverters.*
final case class GetPackageVersionAssetRequest(
    domain: DomainName,
    domainOwner: Option[AccountId] = None,
    repository: RepositoryName,
    format: zio.aws.codeartifact.model.PackageFormat,
    namespace: Option[PackageNamespace] = None,
    packageValue: PackageName,
    packageVersion: PackageVersion,
    asset: AssetName,
    packageVersionRevision: Option[PackageVersionRevision] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.GetPackageVersionAssetRequest = {
    import GetPackageVersionAssetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.GetPackageVersionAssetRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .repository(RepositoryName.unwrap(repository): java.lang.String)
      .format(format.unwrap)
      .optionallyWith(
        namespace.map(value => PackageNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .packageValue(PackageName.unwrap(packageValue): java.lang.String)
      .packageVersion(PackageVersion.unwrap(packageVersion): java.lang.String)
      .asset(AssetName.unwrap(asset): java.lang.String)
      .optionallyWith(
        packageVersionRevision.map(value =>
          PackageVersionRevision.unwrap(value): java.lang.String
        )
      )(_.packageVersionRevision)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.GetPackageVersionAssetRequest.ReadOnly =
    zio.aws.codeartifact.model.GetPackageVersionAssetRequest
      .wrap(buildAwsValue())
}
object GetPackageVersionAssetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.GetPackageVersionAssetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.GetPackageVersionAssetRequest =
      zio.aws.codeartifact.model.GetPackageVersionAssetRequest(
        domain,
        domainOwner.map(value => value),
        repository,
        format,
        namespace.map(value => value),
        packageValue,
        packageVersion,
        asset,
        packageVersionRevision.map(value => value)
      )
    def domain: DomainName
    def domainOwner: Option[AccountId]
    def repository: RepositoryName
    def format: zio.aws.codeartifact.model.PackageFormat
    def namespace: Option[PackageNamespace]
    def packageValue: PackageName
    def packageVersion: PackageVersion
    def asset: AssetName
    def packageVersionRevision: Option[PackageVersionRevision]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
    def getRepository: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repository)
    def getFormat: ZIO[Any, Nothing, zio.aws.codeartifact.model.PackageFormat] =
      ZIO.succeed(format)
    def getNamespace: ZIO[Any, AwsError, PackageNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getPackageValue: ZIO[Any, Nothing, PackageName] =
      ZIO.succeed(packageValue)
    def getPackageVersion: ZIO[Any, Nothing, PackageVersion] =
      ZIO.succeed(packageVersion)
    def getAsset: ZIO[Any, Nothing, AssetName] = ZIO.succeed(asset)
    def getPackageVersionRevision: ZIO[Any, AwsError, PackageVersionRevision] =
      AwsError.unwrapOptionField(
        "packageVersionRevision",
        packageVersionRevision
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.GetPackageVersionAssetRequest
  ) extends zio.aws.codeartifact.model.GetPackageVersionAssetRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.codeartifact.model.primitives.DomainName(impl.domain())
    override val domainOwner: Option[AccountId] = scala
      .Option(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val repository: RepositoryName =
      zio.aws.codeartifact.model.primitives.RepositoryName(impl.repository())
    override val format: zio.aws.codeartifact.model.PackageFormat =
      zio.aws.codeartifact.model.PackageFormat.wrap(impl.format())
    override val namespace: Option[PackageNamespace] = scala
      .Option(impl.namespace())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PackageNamespace(value)
      )
    override val packageValue: PackageName =
      zio.aws.codeartifact.model.primitives.PackageName(impl.packageValue())
    override val packageVersion: PackageVersion =
      zio.aws.codeartifact.model.primitives
        .PackageVersion(impl.packageVersion())
    override val asset: AssetName =
      zio.aws.codeartifact.model.primitives.AssetName(impl.asset())
    override val packageVersionRevision: Option[PackageVersionRevision] = scala
      .Option(impl.packageVersionRevision())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PackageVersionRevision(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.GetPackageVersionAssetRequest
  ): zio.aws.codeartifact.model.GetPackageVersionAssetRequest.ReadOnly =
    new Wrapper(impl)
}
