package zio.aws.codeartifact.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.{
  PaginationToken,
  ListDomainsMaxResults
}
import scala.jdk.CollectionConverters.*
final case class ListDomainsRequest(
    maxResults: Option[ListDomainsMaxResults] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.ListDomainsRequest = {
    import ListDomainsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.ListDomainsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => ListDomainsMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.ListDomainsRequest.ReadOnly =
    zio.aws.codeartifact.model.ListDomainsRequest.wrap(buildAwsValue())
}
object ListDomainsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.ListDomainsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.ListDomainsRequest =
      zio.aws.codeartifact.model.ListDomainsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[ListDomainsMaxResults]
    def nextToken: Option[PaginationToken]
    def getMaxResults: ZIO[Any, AwsError, ListDomainsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.ListDomainsRequest
  ) extends zio.aws.codeartifact.model.ListDomainsRequest.ReadOnly {
    override val maxResults: Option[ListDomainsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.codeartifact.model.primitives.ListDomainsMaxResults(value)
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.ListDomainsRequest
  ): zio.aws.codeartifact.model.ListDomainsRequest.ReadOnly = new Wrapper(impl)
}
