package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListRepositoriesInDomainResponse(
    repositories: Option[
      Iterable[zio.aws.codeartifact.model.RepositorySummary]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainResponse = {
    import ListRepositoriesInDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainResponse
      .builder()
      .optionallyWith(
        repositories.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.repositories)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.ListRepositoriesInDomainResponse.ReadOnly =
    zio.aws.codeartifact.model.ListRepositoriesInDomainResponse
      .wrap(buildAwsValue())
}
object ListRepositoriesInDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeartifact.model.ListRepositoriesInDomainResponse =
      zio.aws.codeartifact.model.ListRepositoriesInDomainResponse(
        repositories.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def repositories
        : Option[List[zio.aws.codeartifact.model.RepositorySummary.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getRepositories: ZIO[Any, AwsError, List[
      zio.aws.codeartifact.model.RepositorySummary.ReadOnly
    ]] = AwsError.unwrapOptionField("repositories", repositories)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainResponse
  ) extends zio.aws.codeartifact.model.ListRepositoriesInDomainResponse.ReadOnly {
    override val repositories
        : Option[List[zio.aws.codeartifact.model.RepositorySummary.ReadOnly]] =
      scala
        .Option(impl.repositories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codeartifact.model.RepositorySummary.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainResponse
  ): zio.aws.codeartifact.model.ListRepositoriesInDomainResponse.ReadOnly =
    new Wrapper(impl)
}
