package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRepositoryPermissionsPolicyResponse(
    policy: Option[zio.aws.codeartifact.model.ResourcePolicy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.GetRepositoryPermissionsPolicyResponse = {
    import GetRepositoryPermissionsPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.GetRepositoryPermissionsPolicyResponse
      .builder()
      .optionallyWith(policy.map(value => value.buildAwsValue()))(_.policy)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.GetRepositoryPermissionsPolicyResponse.ReadOnly =
    zio.aws.codeartifact.model.GetRepositoryPermissionsPolicyResponse
      .wrap(buildAwsValue())
}
object GetRepositoryPermissionsPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.GetRepositoryPermissionsPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeartifact.model.GetRepositoryPermissionsPolicyResponse =
      zio.aws.codeartifact.model.GetRepositoryPermissionsPolicyResponse(
        policy.map(value => value.asEditable)
      )
    def policy: Option[zio.aws.codeartifact.model.ResourcePolicy.ReadOnly]
    def getPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.codeartifact.model.ResourcePolicy.ReadOnly
    ] = AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.GetRepositoryPermissionsPolicyResponse
  ) extends zio.aws.codeartifact.model.GetRepositoryPermissionsPolicyResponse.ReadOnly {
    override val policy
        : Option[zio.aws.codeartifact.model.ResourcePolicy.ReadOnly] = scala
      .Option(impl.policy())
      .map(value => zio.aws.codeartifact.model.ResourcePolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.GetRepositoryPermissionsPolicyResponse
  ): zio.aws.codeartifact.model.GetRepositoryPermissionsPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
