package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListPackagesResponse(
    packages: Option[Iterable[zio.aws.codeartifact.model.PackageSummary]] =
      None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.ListPackagesResponse = {
    import ListPackagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.ListPackagesResponse
      .builder()
      .optionallyWith(
        packages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.packages)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.ListPackagesResponse.ReadOnly =
    zio.aws.codeartifact.model.ListPackagesResponse.wrap(buildAwsValue())
}
object ListPackagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.ListPackagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.ListPackagesResponse =
      zio.aws.codeartifact.model.ListPackagesResponse(
        packages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def packages
        : Option[List[zio.aws.codeartifact.model.PackageSummary.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getPackages: ZIO[Any, AwsError, List[
      zio.aws.codeartifact.model.PackageSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("packages", packages)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.ListPackagesResponse
  ) extends zio.aws.codeartifact.model.ListPackagesResponse.ReadOnly {
    override val packages
        : Option[List[zio.aws.codeartifact.model.PackageSummary.ReadOnly]] =
      scala
        .Option(impl.packages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codeartifact.model.PackageSummary.wrap(item)
          }.toList
        )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.ListPackagesResponse
  ): zio.aws.codeartifact.model.ListPackagesResponse.ReadOnly = new Wrapper(
    impl
  )
}
