package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.{
  PolicyRevision,
  AccountId,
  DomainName,
  RepositoryName,
  PolicyDocument
}
import scala.jdk.CollectionConverters.*
final case class PutRepositoryPermissionsPolicyRequest(
    domain: DomainName,
    domainOwner: Option[AccountId] = None,
    repository: RepositoryName,
    policyRevision: Option[PolicyRevision] = None,
    policyDocument: PolicyDocument
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.PutRepositoryPermissionsPolicyRequest = {
    import PutRepositoryPermissionsPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.PutRepositoryPermissionsPolicyRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .repository(RepositoryName.unwrap(repository): java.lang.String)
      .optionallyWith(
        policyRevision.map(value =>
          PolicyRevision.unwrap(value): java.lang.String
        )
      )(_.policyRevision)
      .policyDocument(PolicyDocument.unwrap(policyDocument): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.PutRepositoryPermissionsPolicyRequest.ReadOnly =
    zio.aws.codeartifact.model.PutRepositoryPermissionsPolicyRequest
      .wrap(buildAwsValue())
}
object PutRepositoryPermissionsPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.PutRepositoryPermissionsPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeartifact.model.PutRepositoryPermissionsPolicyRequest =
      zio.aws.codeartifact.model.PutRepositoryPermissionsPolicyRequest(
        domain,
        domainOwner.map(value => value),
        repository,
        policyRevision.map(value => value),
        policyDocument
      )
    def domain: DomainName
    def domainOwner: Option[AccountId]
    def repository: RepositoryName
    def policyRevision: Option[PolicyRevision]
    def policyDocument: PolicyDocument
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
    def getRepository: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repository)
    def getPolicyRevision: ZIO[Any, AwsError, PolicyRevision] =
      AwsError.unwrapOptionField("policyRevision", policyRevision)
    def getPolicyDocument: ZIO[Any, Nothing, PolicyDocument] =
      ZIO.succeed(policyDocument)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.PutRepositoryPermissionsPolicyRequest
  ) extends zio.aws.codeartifact.model.PutRepositoryPermissionsPolicyRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.codeartifact.model.primitives.DomainName(impl.domain())
    override val domainOwner: Option[AccountId] = scala
      .Option(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val repository: RepositoryName =
      zio.aws.codeartifact.model.primitives.RepositoryName(impl.repository())
    override val policyRevision: Option[PolicyRevision] = scala
      .Option(impl.policyRevision())
      .map(value => zio.aws.codeartifact.model.primitives.PolicyRevision(value))
    override val policyDocument: PolicyDocument =
      zio.aws.codeartifact.model.primitives
        .PolicyDocument(impl.policyDocument())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.PutRepositoryPermissionsPolicyRequest
  ): zio.aws.codeartifact.model.PutRepositoryPermissionsPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
