package zio.aws.codeartifact.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.{
  AccountId,
  ListRepositoriesInDomainMaxResults,
  DomainName,
  RepositoryName,
  PaginationToken
}
import scala.jdk.CollectionConverters.*
final case class ListRepositoriesInDomainRequest(
    domain: DomainName,
    domainOwner: Option[AccountId] = None,
    administratorAccount: Option[AccountId] = None,
    repositoryPrefix: Option[RepositoryName] = None,
    maxResults: Option[ListRepositoriesInDomainMaxResults] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainRequest = {
    import ListRepositoriesInDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .optionallyWith(
        administratorAccount.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.administratorAccount)
      .optionallyWith(
        repositoryPrefix.map(value =>
          RepositoryName.unwrap(value): java.lang.String
        )
      )(_.repositoryPrefix)
      .optionallyWith(
        maxResults.map(value =>
          ListRepositoriesInDomainMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.ListRepositoriesInDomainRequest.ReadOnly =
    zio.aws.codeartifact.model.ListRepositoriesInDomainRequest
      .wrap(buildAwsValue())
}
object ListRepositoriesInDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.ListRepositoriesInDomainRequest =
      zio.aws.codeartifact.model.ListRepositoriesInDomainRequest(
        domain,
        domainOwner.map(value => value),
        administratorAccount.map(value => value),
        repositoryPrefix.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def domain: DomainName
    def domainOwner: Option[AccountId]
    def administratorAccount: Option[AccountId]
    def repositoryPrefix: Option[RepositoryName]
    def maxResults: Option[ListRepositoriesInDomainMaxResults]
    def nextToken: Option[PaginationToken]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
    def getAdministratorAccount: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("administratorAccount", administratorAccount)
    def getRepositoryPrefix: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("repositoryPrefix", repositoryPrefix)
    def getMaxResults: ZIO[Any, AwsError, ListRepositoriesInDomainMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainRequest
  ) extends zio.aws.codeartifact.model.ListRepositoriesInDomainRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.codeartifact.model.primitives.DomainName(impl.domain())
    override val domainOwner: Option[AccountId] = scala
      .Option(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val administratorAccount: Option[AccountId] = scala
      .Option(impl.administratorAccount())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val repositoryPrefix: Option[RepositoryName] = scala
      .Option(impl.repositoryPrefix())
      .map(value => zio.aws.codeartifact.model.primitives.RepositoryName(value))
    override val maxResults: Option[ListRepositoriesInDomainMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.codeartifact.model.primitives
          .ListRepositoriesInDomainMaxResults(value)
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainRequest
  ): zio.aws.codeartifact.model.ListRepositoriesInDomainRequest.ReadOnly =
    new Wrapper(impl)
}
