package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.{AccountId, DomainName}
import scala.jdk.CollectionConverters.*
final case class GetDomainPermissionsPolicyRequest(
    domain: DomainName,
    domainOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.GetDomainPermissionsPolicyRequest = {
    import GetDomainPermissionsPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.GetDomainPermissionsPolicyRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.GetDomainPermissionsPolicyRequest.ReadOnly =
    zio.aws.codeartifact.model.GetDomainPermissionsPolicyRequest
      .wrap(buildAwsValue())
}
object GetDomainPermissionsPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.GetDomainPermissionsPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeartifact.model.GetDomainPermissionsPolicyRequest =
      zio.aws.codeartifact.model.GetDomainPermissionsPolicyRequest(
        domain,
        domainOwner.map(value => value)
      )
    def domain: DomainName
    def domainOwner: Option[AccountId]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.GetDomainPermissionsPolicyRequest
  ) extends zio.aws.codeartifact.model.GetDomainPermissionsPolicyRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.codeartifact.model.primitives.DomainName(impl.domain())
    override val domainOwner: Option[AccountId] = scala
      .Option(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.GetDomainPermissionsPolicyRequest
  ): zio.aws.codeartifact.model.GetDomainPermissionsPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
