package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.{
  PackageName,
  AccountId,
  BooleanOptional,
  DomainName,
  RepositoryName,
  PackageVersion,
  PackageNamespace,
  PackageVersionRevision
}
import scala.jdk.CollectionConverters.*
final case class CopyPackageVersionsRequest(
    domain: DomainName,
    domainOwner: Option[AccountId] = None,
    sourceRepository: RepositoryName,
    destinationRepository: RepositoryName,
    format: zio.aws.codeartifact.model.PackageFormat,
    namespace: Option[PackageNamespace] = None,
    packageValue: PackageName,
    versions: Option[Iterable[PackageVersion]] = None,
    versionRevisions: Option[Map[PackageVersion, PackageVersionRevision]] =
      None,
    allowOverwrite: Option[BooleanOptional] = None,
    includeFromUpstream: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.CopyPackageVersionsRequest = {
    import CopyPackageVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.CopyPackageVersionsRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .sourceRepository(
        RepositoryName.unwrap(sourceRepository): java.lang.String
      )
      .destinationRepository(
        RepositoryName.unwrap(destinationRepository): java.lang.String
      )
      .format(format.unwrap)
      .optionallyWith(
        namespace.map(value => PackageNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .packageValue(PackageName.unwrap(packageValue): java.lang.String)
      .optionallyWith(
        versions.map(value =>
          value.map { item =>
            PackageVersion.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.versions)
      .optionallyWith(
        versionRevisions.map(value =>
          value
            .map({ case (key, value) =>
              (PackageVersion.unwrap(
                key
              ): java.lang.String) -> (PackageVersionRevision.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.versionRevisions)
      .optionallyWith(
        allowOverwrite.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.allowOverwrite)
      .optionallyWith(
        includeFromUpstream.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.includeFromUpstream)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.CopyPackageVersionsRequest.ReadOnly =
    zio.aws.codeartifact.model.CopyPackageVersionsRequest.wrap(buildAwsValue())
}
object CopyPackageVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.CopyPackageVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.CopyPackageVersionsRequest =
      zio.aws.codeartifact.model.CopyPackageVersionsRequest(
        domain,
        domainOwner.map(value => value),
        sourceRepository,
        destinationRepository,
        format,
        namespace.map(value => value),
        packageValue,
        versions.map(value => value),
        versionRevisions.map(value => value),
        allowOverwrite.map(value => value),
        includeFromUpstream.map(value => value)
      )
    def domain: DomainName
    def domainOwner: Option[AccountId]
    def sourceRepository: RepositoryName
    def destinationRepository: RepositoryName
    def format: zio.aws.codeartifact.model.PackageFormat
    def namespace: Option[PackageNamespace]
    def packageValue: PackageName
    def versions: Option[List[PackageVersion]]
    def versionRevisions: Option[Map[PackageVersion, PackageVersionRevision]]
    def allowOverwrite: Option[BooleanOptional]
    def includeFromUpstream: Option[BooleanOptional]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
    def getSourceRepository: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(sourceRepository)
    def getDestinationRepository: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(destinationRepository)
    def getFormat: ZIO[Any, Nothing, zio.aws.codeartifact.model.PackageFormat] =
      ZIO.succeed(format)
    def getNamespace: ZIO[Any, AwsError, PackageNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getPackageValue: ZIO[Any, Nothing, PackageName] =
      ZIO.succeed(packageValue)
    def getVersions: ZIO[Any, AwsError, List[PackageVersion]] =
      AwsError.unwrapOptionField("versions", versions)
    def getVersionRevisions
        : ZIO[Any, AwsError, Map[PackageVersion, PackageVersionRevision]] =
      AwsError.unwrapOptionField("versionRevisions", versionRevisions)
    def getAllowOverwrite: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("allowOverwrite", allowOverwrite)
    def getIncludeFromUpstream: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("includeFromUpstream", includeFromUpstream)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.CopyPackageVersionsRequest
  ) extends zio.aws.codeartifact.model.CopyPackageVersionsRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.codeartifact.model.primitives.DomainName(impl.domain())
    override val domainOwner: Option[AccountId] = scala
      .Option(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val sourceRepository: RepositoryName =
      zio.aws.codeartifact.model.primitives
        .RepositoryName(impl.sourceRepository())
    override val destinationRepository: RepositoryName =
      zio.aws.codeartifact.model.primitives
        .RepositoryName(impl.destinationRepository())
    override val format: zio.aws.codeartifact.model.PackageFormat =
      zio.aws.codeartifact.model.PackageFormat.wrap(impl.format())
    override val namespace: Option[PackageNamespace] = scala
      .Option(impl.namespace())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PackageNamespace(value)
      )
    override val packageValue: PackageName =
      zio.aws.codeartifact.model.primitives.PackageName(impl.packageValue())
    override val versions: Option[List[PackageVersion]] = scala
      .Option(impl.versions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codeartifact.model.primitives.PackageVersion(item)
        }.toList
      )
    override val versionRevisions
        : Option[Map[PackageVersion, PackageVersionRevision]] = scala
      .Option(impl.versionRevisions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codeartifact.model.primitives
              .PackageVersion(key) -> zio.aws.codeartifact.model.primitives
              .PackageVersionRevision(value)
          })
          .toMap
      )
    override val allowOverwrite: Option[BooleanOptional] = scala
      .Option(impl.allowOverwrite())
      .map(value =>
        zio.aws.codeartifact.model.primitives.BooleanOptional(value)
      )
    override val includeFromUpstream: Option[BooleanOptional] = scala
      .Option(impl.includeFromUpstream())
      .map(value =>
        zio.aws.codeartifact.model.primitives.BooleanOptional(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.CopyPackageVersionsRequest
  ): zio.aws.codeartifact.model.CopyPackageVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
