package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.{
  AuthorizationTokenDurationSeconds,
  AccountId,
  DomainName
}
import scala.jdk.CollectionConverters.*
final case class GetAuthorizationTokenRequest(
    domain: DomainName,
    domainOwner: Option[AccountId] = None,
    durationSeconds: Option[AuthorizationTokenDurationSeconds] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.GetAuthorizationTokenRequest = {
    import GetAuthorizationTokenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.GetAuthorizationTokenRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .optionallyWith(
        durationSeconds.map(value =>
          AuthorizationTokenDurationSeconds.unwrap(value): java.lang.Long
        )
      )(_.durationSeconds)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.GetAuthorizationTokenRequest.ReadOnly =
    zio.aws.codeartifact.model.GetAuthorizationTokenRequest
      .wrap(buildAwsValue())
}
object GetAuthorizationTokenRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.GetAuthorizationTokenRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.GetAuthorizationTokenRequest =
      zio.aws.codeartifact.model.GetAuthorizationTokenRequest(
        domain,
        domainOwner.map(value => value),
        durationSeconds.map(value => value)
      )
    def domain: DomainName
    def domainOwner: Option[AccountId]
    def durationSeconds: Option[AuthorizationTokenDurationSeconds]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
    def getDurationSeconds
        : ZIO[Any, AwsError, AuthorizationTokenDurationSeconds] =
      AwsError.unwrapOptionField("durationSeconds", durationSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.GetAuthorizationTokenRequest
  ) extends zio.aws.codeartifact.model.GetAuthorizationTokenRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.codeartifact.model.primitives.DomainName(impl.domain())
    override val domainOwner: Option[AccountId] = scala
      .Option(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val durationSeconds: Option[AuthorizationTokenDurationSeconds] =
      scala
        .Option(impl.durationSeconds())
        .map(value =>
          zio.aws.codeartifact.model.primitives
            .AuthorizationTokenDurationSeconds(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.GetAuthorizationTokenRequest
  ): zio.aws.codeartifact.model.GetAuthorizationTokenRequest.ReadOnly =
    new Wrapper(impl)
}
