package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AssociateExternalConnectionResponse(
    repository: Option[zio.aws.codeartifact.model.RepositoryDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.AssociateExternalConnectionResponse = {
    import AssociateExternalConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.AssociateExternalConnectionResponse
      .builder()
      .optionallyWith(repository.map(value => value.buildAwsValue()))(
        _.repository
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.AssociateExternalConnectionResponse.ReadOnly =
    zio.aws.codeartifact.model.AssociateExternalConnectionResponse
      .wrap(buildAwsValue())
}
object AssociateExternalConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.AssociateExternalConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeartifact.model.AssociateExternalConnectionResponse =
      zio.aws.codeartifact.model.AssociateExternalConnectionResponse(
        repository.map(value => value.asEditable)
      )
    def repository
        : Option[zio.aws.codeartifact.model.RepositoryDescription.ReadOnly]
    def getRepository: ZIO[
      Any,
      AwsError,
      zio.aws.codeartifact.model.RepositoryDescription.ReadOnly
    ] = AwsError.unwrapOptionField("repository", repository)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.AssociateExternalConnectionResponse
  ) extends zio.aws.codeartifact.model.AssociateExternalConnectionResponse.ReadOnly {
    override val repository
        : Option[zio.aws.codeartifact.model.RepositoryDescription.ReadOnly] =
      scala
        .Option(impl.repository())
        .map(value =>
          zio.aws.codeartifact.model.RepositoryDescription.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.AssociateExternalConnectionResponse
  ): zio.aws.codeartifact.model.AssociateExternalConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
