package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.{
  PaginationToken,
  PackageName,
  PackageNamespace,
  PackageVersion
}
import scala.jdk.CollectionConverters.*
final case class ListPackageVersionsResponse(
    defaultDisplayVersion: Option[PackageVersion] = None,
    format: Option[zio.aws.codeartifact.model.PackageFormat] = None,
    namespace: Option[PackageNamespace] = None,
    packageValue: Option[PackageName] = None,
    versions: Option[
      Iterable[zio.aws.codeartifact.model.PackageVersionSummary]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsResponse = {
    import ListPackageVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsResponse
      .builder()
      .optionallyWith(
        defaultDisplayVersion.map(value =>
          PackageVersion.unwrap(value): java.lang.String
        )
      )(_.defaultDisplayVersion)
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(
        namespace.map(value => PackageNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        packageValue.map(value => PackageName.unwrap(value): java.lang.String)
      )(_.packageValue)
      .optionallyWith(
        versions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.versions)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.ListPackageVersionsResponse.ReadOnly =
    zio.aws.codeartifact.model.ListPackageVersionsResponse.wrap(buildAwsValue())
}
object ListPackageVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.ListPackageVersionsResponse =
      zio.aws.codeartifact.model.ListPackageVersionsResponse(
        defaultDisplayVersion.map(value => value),
        format.map(value => value),
        namespace.map(value => value),
        packageValue.map(value => value),
        versions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def defaultDisplayVersion: Option[PackageVersion]
    def format: Option[zio.aws.codeartifact.model.PackageFormat]
    def namespace: Option[PackageNamespace]
    def packageValue: Option[PackageName]
    def versions: Option[
      List[zio.aws.codeartifact.model.PackageVersionSummary.ReadOnly]
    ]
    def nextToken: Option[PaginationToken]
    def getDefaultDisplayVersion: ZIO[Any, AwsError, PackageVersion] =
      AwsError.unwrapOptionField("defaultDisplayVersion", defaultDisplayVersion)
    def getFormat
        : ZIO[Any, AwsError, zio.aws.codeartifact.model.PackageFormat] =
      AwsError.unwrapOptionField("format", format)
    def getNamespace: ZIO[Any, AwsError, PackageNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getPackageValue: ZIO[Any, AwsError, PackageName] =
      AwsError.unwrapOptionField("packageValue", packageValue)
    def getVersions: ZIO[Any, AwsError, List[
      zio.aws.codeartifact.model.PackageVersionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("versions", versions)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsResponse
  ) extends zio.aws.codeartifact.model.ListPackageVersionsResponse.ReadOnly {
    override val defaultDisplayVersion: Option[PackageVersion] = scala
      .Option(impl.defaultDisplayVersion())
      .map(value => zio.aws.codeartifact.model.primitives.PackageVersion(value))
    override val format: Option[zio.aws.codeartifact.model.PackageFormat] =
      scala
        .Option(impl.format())
        .map(value => zio.aws.codeartifact.model.PackageFormat.wrap(value))
    override val namespace: Option[PackageNamespace] = scala
      .Option(impl.namespace())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PackageNamespace(value)
      )
    override val packageValue: Option[PackageName] = scala
      .Option(impl.packageValue())
      .map(value => zio.aws.codeartifact.model.primitives.PackageName(value))
    override val versions: Option[
      List[zio.aws.codeartifact.model.PackageVersionSummary.ReadOnly]
    ] = scala
      .Option(impl.versions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codeartifact.model.PackageVersionSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsResponse
  ): zio.aws.codeartifact.model.ListPackageVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
