package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateRepositoryResponse(
    repository: Option[zio.aws.codeartifact.model.RepositoryDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.CreateRepositoryResponse = {
    import CreateRepositoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.CreateRepositoryResponse
      .builder()
      .optionallyWith(repository.map(value => value.buildAwsValue()))(
        _.repository
      )
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.CreateRepositoryResponse.ReadOnly =
    zio.aws.codeartifact.model.CreateRepositoryResponse.wrap(buildAwsValue())
}
object CreateRepositoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.CreateRepositoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.CreateRepositoryResponse =
      zio.aws.codeartifact.model
        .CreateRepositoryResponse(repository.map(value => value.asEditable))
    def repository
        : Option[zio.aws.codeartifact.model.RepositoryDescription.ReadOnly]
    def getRepository: ZIO[
      Any,
      AwsError,
      zio.aws.codeartifact.model.RepositoryDescription.ReadOnly
    ] = AwsError.unwrapOptionField("repository", repository)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.CreateRepositoryResponse
  ) extends zio.aws.codeartifact.model.CreateRepositoryResponse.ReadOnly {
    override val repository
        : Option[zio.aws.codeartifact.model.RepositoryDescription.ReadOnly] =
      scala
        .Option(impl.repository())
        .map(value =>
          zio.aws.codeartifact.model.RepositoryDescription.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.CreateRepositoryResponse
  ): zio.aws.codeartifact.model.CreateRepositoryResponse.ReadOnly = new Wrapper(
    impl
  )
}
