package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.{
  AccountId,
  DomainName,
  RepositoryName,
  Arn,
  Description
}
import scala.jdk.CollectionConverters.*
final case class RepositoryDescription(
    name: Option[RepositoryName] = None,
    administratorAccount: Option[AccountId] = None,
    domainName: Option[DomainName] = None,
    domainOwner: Option[AccountId] = None,
    arn: Option[Arn] = None,
    description: Option[Description] = None,
    upstreams: Option[
      Iterable[zio.aws.codeartifact.model.UpstreamRepositoryInfo]
    ] = None,
    externalConnections: Option[
      Iterable[zio.aws.codeartifact.model.RepositoryExternalConnectionInfo]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.RepositoryDescription = {
    import RepositoryDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.RepositoryDescription
      .builder()
      .optionallyWith(
        name.map(value => RepositoryName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        administratorAccount.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.administratorAccount)
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        upstreams.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.upstreams)
      .optionallyWith(
        externalConnections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.externalConnections)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.RepositoryDescription.ReadOnly =
    zio.aws.codeartifact.model.RepositoryDescription.wrap(buildAwsValue())
}
object RepositoryDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.RepositoryDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.RepositoryDescription =
      zio.aws.codeartifact.model.RepositoryDescription(
        name.map(value => value),
        administratorAccount.map(value => value),
        domainName.map(value => value),
        domainOwner.map(value => value),
        arn.map(value => value),
        description.map(value => value),
        upstreams.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        externalConnections.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Option[RepositoryName]
    def administratorAccount: Option[AccountId]
    def domainName: Option[DomainName]
    def domainOwner: Option[AccountId]
    def arn: Option[Arn]
    def description: Option[Description]
    def upstreams: Option[
      List[zio.aws.codeartifact.model.UpstreamRepositoryInfo.ReadOnly]
    ]
    def externalConnections: Option[
      List[zio.aws.codeartifact.model.RepositoryExternalConnectionInfo.ReadOnly]
    ]
    def getName: ZIO[Any, AwsError, RepositoryName] =
      AwsError.unwrapOptionField("name", name)
    def getAdministratorAccount: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("administratorAccount", administratorAccount)
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getUpstreams: ZIO[Any, AwsError, List[
      zio.aws.codeartifact.model.UpstreamRepositoryInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("upstreams", upstreams)
    def getExternalConnections: ZIO[Any, AwsError, List[
      zio.aws.codeartifact.model.RepositoryExternalConnectionInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("externalConnections", externalConnections)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.RepositoryDescription
  ) extends zio.aws.codeartifact.model.RepositoryDescription.ReadOnly {
    override val name: Option[RepositoryName] = scala
      .Option(impl.name())
      .map(value => zio.aws.codeartifact.model.primitives.RepositoryName(value))
    override val administratorAccount: Option[AccountId] = scala
      .Option(impl.administratorAccount())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val domainName: Option[DomainName] = scala
      .Option(impl.domainName())
      .map(value => zio.aws.codeartifact.model.primitives.DomainName(value))
    override val domainOwner: Option[AccountId] = scala
      .Option(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.codeartifact.model.primitives.Arn(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.codeartifact.model.primitives.Description(value))
    override val upstreams: Option[
      List[zio.aws.codeartifact.model.UpstreamRepositoryInfo.ReadOnly]
    ] = scala
      .Option(impl.upstreams())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codeartifact.model.UpstreamRepositoryInfo.wrap(item)
        }.toList
      )
    override val externalConnections: Option[
      List[zio.aws.codeartifact.model.RepositoryExternalConnectionInfo.ReadOnly]
    ] = scala
      .Option(impl.externalConnections())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codeartifact.model.RepositoryExternalConnectionInfo.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.RepositoryDescription
  ): zio.aws.codeartifact.model.RepositoryDescription.ReadOnly = new Wrapper(
    impl
  )
}
