package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.{AccountId, DomainName}
import scala.jdk.CollectionConverters.*
final case class DeleteDomainRequest(
    domain: DomainName,
    domainOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.DeleteDomainRequest = {
    import DeleteDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.DeleteDomainRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.DeleteDomainRequest.ReadOnly =
    zio.aws.codeartifact.model.DeleteDomainRequest.wrap(buildAwsValue())
}
object DeleteDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.DeleteDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.DeleteDomainRequest =
      zio.aws.codeartifact.model
        .DeleteDomainRequest(domain, domainOwner.map(value => value))
    def domain: DomainName
    def domainOwner: Option[AccountId]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.DeleteDomainRequest
  ) extends zio.aws.codeartifact.model.DeleteDomainRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.codeartifact.model.primitives.DomainName(impl.domain())
    override val domainOwner: Option[AccountId] = scala
      .Option(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.DeleteDomainRequest
  ): zio.aws.codeartifact.model.DeleteDomainRequest.ReadOnly = new Wrapper(impl)
}
