package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.PackageVersion
import scala.jdk.CollectionConverters.*
final case class CopyPackageVersionsResponse(
    successfulVersions: Option[Map[
      PackageVersion,
      zio.aws.codeartifact.model.SuccessfulPackageVersionInfo
    ]] = None,
    failedVersions: Option[
      Map[PackageVersion, zio.aws.codeartifact.model.PackageVersionError]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.CopyPackageVersionsResponse = {
    import CopyPackageVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.CopyPackageVersionsResponse
      .builder()
      .optionallyWith(
        successfulVersions.map(value =>
          value
            .map({ case (key, value) =>
              (PackageVersion.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.successfulVersions)
      .optionallyWith(
        failedVersions.map(value =>
          value
            .map({ case (key, value) =>
              (PackageVersion.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.failedVersions)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.CopyPackageVersionsResponse.ReadOnly =
    zio.aws.codeartifact.model.CopyPackageVersionsResponse.wrap(buildAwsValue())
}
object CopyPackageVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.CopyPackageVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.CopyPackageVersionsResponse =
      zio.aws.codeartifact.model.CopyPackageVersionsResponse(
        successfulVersions.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        failedVersions.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def successfulVersions: Option[Map[
      PackageVersion,
      zio.aws.codeartifact.model.SuccessfulPackageVersionInfo.ReadOnly
    ]]
    def failedVersions: Option[Map[
      PackageVersion,
      zio.aws.codeartifact.model.PackageVersionError.ReadOnly
    ]]
    def getSuccessfulVersions: ZIO[Any, AwsError, Map[
      PackageVersion,
      zio.aws.codeartifact.model.SuccessfulPackageVersionInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("successfulVersions", successfulVersions)
    def getFailedVersions: ZIO[Any, AwsError, Map[
      PackageVersion,
      zio.aws.codeartifact.model.PackageVersionError.ReadOnly
    ]] = AwsError.unwrapOptionField("failedVersions", failedVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.CopyPackageVersionsResponse
  ) extends zio.aws.codeartifact.model.CopyPackageVersionsResponse.ReadOnly {
    override val successfulVersions: Option[Map[
      PackageVersion,
      zio.aws.codeartifact.model.SuccessfulPackageVersionInfo.ReadOnly
    ]] = scala
      .Option(impl.successfulVersions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codeartifact.model.primitives.PackageVersion(
              key
            ) -> zio.aws.codeartifact.model.SuccessfulPackageVersionInfo
              .wrap(value)
          })
          .toMap
      )
    override val failedVersions: Option[Map[
      PackageVersion,
      zio.aws.codeartifact.model.PackageVersionError.ReadOnly
    ]] = scala
      .Option(impl.failedVersions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codeartifact.model.primitives.PackageVersion(
              key
            ) -> zio.aws.codeartifact.model.PackageVersionError.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.CopyPackageVersionsResponse
  ): zio.aws.codeartifact.model.CopyPackageVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
