package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codeartifact.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.codeartifact.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.ListTagsForResourceRequest =
      zio.aws.codeartifact.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: Arn
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.ListTagsForResourceRequest
  ) extends zio.aws.codeartifact.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.codeartifact.model.primitives.Arn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.ListTagsForResourceRequest
  ): zio.aws.codeartifact.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
