package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codeartifact.model.primitives.{
  PackageName,
  AccountId,
  DomainName,
  RepositoryName,
  PackageVersion,
  PackageNamespace
}
import scala.jdk.CollectionConverters.*
final case class DescribePackageVersionRequest(
    domain: DomainName,
    domainOwner: Option[AccountId] = None,
    repository: RepositoryName,
    format: zio.aws.codeartifact.model.PackageFormat,
    namespace: Option[PackageNamespace] = None,
    packageValue: PackageName,
    packageVersion: PackageVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.DescribePackageVersionRequest = {
    import DescribePackageVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.DescribePackageVersionRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .repository(RepositoryName.unwrap(repository): java.lang.String)
      .format(format.unwrap)
      .optionallyWith(
        namespace.map(value => PackageNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .packageValue(PackageName.unwrap(packageValue): java.lang.String)
      .packageVersion(PackageVersion.unwrap(packageVersion): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.DescribePackageVersionRequest.ReadOnly =
    zio.aws.codeartifact.model.DescribePackageVersionRequest
      .wrap(buildAwsValue())
}
object DescribePackageVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.DescribePackageVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.DescribePackageVersionRequest =
      zio.aws.codeartifact.model.DescribePackageVersionRequest(
        domain,
        domainOwner.map(value => value),
        repository,
        format,
        namespace.map(value => value),
        packageValue,
        packageVersion
      )
    def domain: DomainName
    def domainOwner: Option[AccountId]
    def repository: RepositoryName
    def format: zio.aws.codeartifact.model.PackageFormat
    def namespace: Option[PackageNamespace]
    def packageValue: PackageName
    def packageVersion: PackageVersion
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
    def getRepository: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repository)
    def getFormat: ZIO[Any, Nothing, zio.aws.codeartifact.model.PackageFormat] =
      ZIO.succeed(format)
    def getNamespace: ZIO[Any, AwsError, PackageNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getPackageValue: ZIO[Any, Nothing, PackageName] =
      ZIO.succeed(packageValue)
    def getPackageVersion: ZIO[Any, Nothing, PackageVersion] =
      ZIO.succeed(packageVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.DescribePackageVersionRequest
  ) extends zio.aws.codeartifact.model.DescribePackageVersionRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.codeartifact.model.primitives.DomainName(impl.domain())
    override val domainOwner: Option[AccountId] = scala
      .Option(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val repository: RepositoryName =
      zio.aws.codeartifact.model.primitives.RepositoryName(impl.repository())
    override val format: zio.aws.codeartifact.model.PackageFormat =
      zio.aws.codeartifact.model.PackageFormat.wrap(impl.format())
    override val namespace: Option[PackageNamespace] = scala
      .Option(impl.namespace())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PackageNamespace(value)
      )
    override val packageValue: PackageName =
      zio.aws.codeartifact.model.primitives.PackageName(impl.packageValue())
    override val packageVersion: PackageVersion =
      zio.aws.codeartifact.model.primitives
        .PackageVersion(impl.packageVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.DescribePackageVersionRequest
  ): zio.aws.codeartifact.model.DescribePackageVersionRequest.ReadOnly =
    new Wrapper(impl)
}
