package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateDomainResponse(
    domain: Option[zio.aws.codeartifact.model.DomainDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.CreateDomainResponse = {
    import CreateDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.CreateDomainResponse
      .builder()
      .optionallyWith(domain.map(value => value.buildAwsValue()))(_.domain)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.CreateDomainResponse.ReadOnly =
    zio.aws.codeartifact.model.CreateDomainResponse.wrap(buildAwsValue())
}
object CreateDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.CreateDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.CreateDomainResponse =
      zio.aws.codeartifact.model
        .CreateDomainResponse(domain.map(value => value.asEditable))
    def domain: Option[zio.aws.codeartifact.model.DomainDescription.ReadOnly]
    def getDomain: ZIO[
      Any,
      AwsError,
      zio.aws.codeartifact.model.DomainDescription.ReadOnly
    ] = AwsError.unwrapOptionField("domain", domain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.CreateDomainResponse
  ) extends zio.aws.codeartifact.model.CreateDomainResponse.ReadOnly {
    override val domain
        : Option[zio.aws.codeartifact.model.DomainDescription.ReadOnly] = scala
      .Option(impl.domain())
      .map(value => zio.aws.codeartifact.model.DomainDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.CreateDomainResponse
  ): zio.aws.codeartifact.model.CreateDomainResponse.ReadOnly = new Wrapper(
    impl
  )
}
