package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeartifact.model.primitives.{
  PackageVersionRevision,
  PackageVersion,
  PackageName,
  PackageNamespace
}
import scala.jdk.CollectionConverters._
final case class PublishPackageVersionResponse(
    format: Optional[zio.aws.codeartifact.model.PackageFormat] =
      Optional.Absent,
    namespace: Optional[PackageNamespace] = Optional.Absent,
    packageValue: Optional[PackageName] = Optional.Absent,
    version: Optional[PackageVersion] = Optional.Absent,
    versionRevision: Optional[PackageVersionRevision] = Optional.Absent,
    status: Optional[zio.aws.codeartifact.model.PackageVersionStatus] =
      Optional.Absent,
    asset: Optional[zio.aws.codeartifact.model.AssetSummary] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.PublishPackageVersionResponse = {
    import PublishPackageVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.PublishPackageVersionResponse
      .builder()
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(
        namespace.map(value => PackageNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        packageValue.map(value => PackageName.unwrap(value): java.lang.String)
      )(_.packageValue)
      .optionallyWith(
        version.map(value => PackageVersion.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        versionRevision.map(value =>
          PackageVersionRevision.unwrap(value): java.lang.String
        )
      )(_.versionRevision)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(asset.map(value => value.buildAwsValue()))(_.asset)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.PublishPackageVersionResponse.ReadOnly =
    zio.aws.codeartifact.model.PublishPackageVersionResponse
      .wrap(buildAwsValue())
}
object PublishPackageVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.PublishPackageVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.PublishPackageVersionResponse =
      zio.aws.codeartifact.model.PublishPackageVersionResponse(
        format.map(value => value),
        namespace.map(value => value),
        packageValue.map(value => value),
        version.map(value => value),
        versionRevision.map(value => value),
        status.map(value => value),
        asset.map(value => value.asEditable)
      )
    def format: Optional[zio.aws.codeartifact.model.PackageFormat]
    def namespace: Optional[PackageNamespace]
    def packageValue: Optional[PackageName]
    def version: Optional[PackageVersion]
    def versionRevision: Optional[PackageVersionRevision]
    def status: Optional[zio.aws.codeartifact.model.PackageVersionStatus]
    def asset: Optional[zio.aws.codeartifact.model.AssetSummary.ReadOnly]
    def getFormat
        : ZIO[Any, AwsError, zio.aws.codeartifact.model.PackageFormat] =
      AwsError.unwrapOptionField("format", format)
    def getNamespace: ZIO[Any, AwsError, PackageNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getPackageValue: ZIO[Any, AwsError, PackageName] =
      AwsError.unwrapOptionField("packageValue", packageValue)
    def getVersion: ZIO[Any, AwsError, PackageVersion] =
      AwsError.unwrapOptionField("version", version)
    def getVersionRevision: ZIO[Any, AwsError, PackageVersionRevision] =
      AwsError.unwrapOptionField("versionRevision", versionRevision)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.codeartifact.model.PackageVersionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getAsset
        : ZIO[Any, AwsError, zio.aws.codeartifact.model.AssetSummary.ReadOnly] =
      AwsError.unwrapOptionField("asset", asset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.PublishPackageVersionResponse
  ) extends zio.aws.codeartifact.model.PublishPackageVersionResponse.ReadOnly {
    override val format: Optional[zio.aws.codeartifact.model.PackageFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.format())
        .map(value => zio.aws.codeartifact.model.PackageFormat.wrap(value))
    override val namespace: Optional[PackageNamespace] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PackageNamespace(value)
      )
    override val packageValue: Optional[PackageName] = zio.aws.core.internal
      .optionalFromNullable(impl.packageValue())
      .map(value => zio.aws.codeartifact.model.primitives.PackageName(value))
    override val version: Optional[PackageVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.codeartifact.model.primitives.PackageVersion(value))
    override val versionRevision: Optional[PackageVersionRevision] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionRevision())
        .map(value =>
          zio.aws.codeartifact.model.primitives.PackageVersionRevision(value)
        )
    override val status
        : Optional[zio.aws.codeartifact.model.PackageVersionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.codeartifact.model.PackageVersionStatus.wrap(value)
        )
    override val asset
        : Optional[zio.aws.codeartifact.model.AssetSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.asset())
        .map(value => zio.aws.codeartifact.model.AssetSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.PublishPackageVersionResponse
  ): zio.aws.codeartifact.model.PublishPackageVersionResponse.ReadOnly =
    new Wrapper(impl)
}
