package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeartifact.model.primitives.{
  PackageName,
  PackageVersion,
  PaginationToken,
  PackageNamespace,
  PackageVersionRevision
}
import scala.jdk.CollectionConverters._
final case class ListPackageVersionAssetsResponse(
    format: Optional[zio.aws.codeartifact.model.PackageFormat] =
      Optional.Absent,
    namespace: Optional[PackageNamespace] = Optional.Absent,
    packageValue: Optional[PackageName] = Optional.Absent,
    version: Optional[PackageVersion] = Optional.Absent,
    versionRevision: Optional[PackageVersionRevision] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    assets: Optional[Iterable[zio.aws.codeartifact.model.AssetSummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.ListPackageVersionAssetsResponse = {
    import ListPackageVersionAssetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.ListPackageVersionAssetsResponse
      .builder()
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(
        namespace.map(value => PackageNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        packageValue.map(value => PackageName.unwrap(value): java.lang.String)
      )(_.packageValue)
      .optionallyWith(
        version.map(value => PackageVersion.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        versionRevision.map(value =>
          PackageVersionRevision.unwrap(value): java.lang.String
        )
      )(_.versionRevision)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        assets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assets)
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.ListPackageVersionAssetsResponse.ReadOnly =
    zio.aws.codeartifact.model.ListPackageVersionAssetsResponse
      .wrap(buildAwsValue())
}
object ListPackageVersionAssetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.ListPackageVersionAssetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codeartifact.model.ListPackageVersionAssetsResponse =
      zio.aws.codeartifact.model.ListPackageVersionAssetsResponse(
        format.map(value => value),
        namespace.map(value => value),
        packageValue.map(value => value),
        version.map(value => value),
        versionRevision.map(value => value),
        nextToken.map(value => value),
        assets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def format: Optional[zio.aws.codeartifact.model.PackageFormat]
    def namespace: Optional[PackageNamespace]
    def packageValue: Optional[PackageName]
    def version: Optional[PackageVersion]
    def versionRevision: Optional[PackageVersionRevision]
    def nextToken: Optional[PaginationToken]
    def assets: Optional[List[zio.aws.codeartifact.model.AssetSummary.ReadOnly]]
    def getFormat
        : ZIO[Any, AwsError, zio.aws.codeartifact.model.PackageFormat] =
      AwsError.unwrapOptionField("format", format)
    def getNamespace: ZIO[Any, AwsError, PackageNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getPackageValue: ZIO[Any, AwsError, PackageName] =
      AwsError.unwrapOptionField("packageValue", packageValue)
    def getVersion: ZIO[Any, AwsError, PackageVersion] =
      AwsError.unwrapOptionField("version", version)
    def getVersionRevision: ZIO[Any, AwsError, PackageVersionRevision] =
      AwsError.unwrapOptionField("versionRevision", versionRevision)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getAssets: ZIO[Any, AwsError, List[
      zio.aws.codeartifact.model.AssetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("assets", assets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.ListPackageVersionAssetsResponse
  ) extends zio.aws.codeartifact.model.ListPackageVersionAssetsResponse.ReadOnly {
    override val format: Optional[zio.aws.codeartifact.model.PackageFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.format())
        .map(value => zio.aws.codeartifact.model.PackageFormat.wrap(value))
    override val namespace: Optional[PackageNamespace] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PackageNamespace(value)
      )
    override val packageValue: Optional[PackageName] = zio.aws.core.internal
      .optionalFromNullable(impl.packageValue())
      .map(value => zio.aws.codeartifact.model.primitives.PackageName(value))
    override val version: Optional[PackageVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.codeartifact.model.primitives.PackageVersion(value))
    override val versionRevision: Optional[PackageVersionRevision] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionRevision())
        .map(value =>
          zio.aws.codeartifact.model.primitives.PackageVersionRevision(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PaginationToken(value)
      )
    override val assets
        : Optional[List[zio.aws.codeartifact.model.AssetSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codeartifact.model.AssetSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.ListPackageVersionAssetsResponse
  ): zio.aws.codeartifact.model.ListPackageVersionAssetsResponse.ReadOnly =
    new Wrapper(impl)
}
