package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LicenseInfo(
    name: Optional[String] = Optional.Absent,
    url: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.LicenseInfo = {
    import LicenseInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.LicenseInfo
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.LicenseInfo.ReadOnly =
    zio.aws.codeartifact.model.LicenseInfo.wrap(buildAwsValue())
}
object LicenseInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.LicenseInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.LicenseInfo =
      zio.aws.codeartifact.model
        .LicenseInfo(name.map(value => value), url.map(value => value))
    def name: Optional[String]
    def url: Optional[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.LicenseInfo
  ) extends zio.aws.codeartifact.model.LicenseInfo.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val url: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.LicenseInfo
  ): zio.aws.codeartifact.model.LicenseInfo.ReadOnly = new Wrapper(impl)
}
