package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeartifact.model.primitives.{Arn, DomainName}
import scala.jdk.CollectionConverters._
final case class CreateDomainRequest(
    domain: DomainName,
    encryptionKey: Optional[Arn] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.codeartifact.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.CreateDomainRequest = {
    import CreateDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.CreateDomainRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(
        encryptionKey.map(value => Arn.unwrap(value): java.lang.String)
      )(_.encryptionKey)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.codeartifact.model.CreateDomainRequest.ReadOnly =
    zio.aws.codeartifact.model.CreateDomainRequest.wrap(buildAwsValue())
}
object CreateDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.CreateDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.CreateDomainRequest =
      zio.aws.codeartifact.model.CreateDomainRequest(
        domain,
        encryptionKey.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def domain: DomainName
    def encryptionKey: Optional[Arn]
    def tags: Optional[List[zio.aws.codeartifact.model.Tag.ReadOnly]]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getEncryptionKey: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("encryptionKey", encryptionKey)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.codeartifact.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.CreateDomainRequest
  ) extends zio.aws.codeartifact.model.CreateDomainRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.codeartifact.model.primitives.DomainName(impl.domain())
    override val encryptionKey: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionKey())
      .map(value => zio.aws.codeartifact.model.primitives.Arn(value))
    override val tags: Optional[List[zio.aws.codeartifact.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codeartifact.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.CreateDomainRequest
  ): zio.aws.codeartifact.model.CreateDomainRequest.ReadOnly = new Wrapper(impl)
}
