package zio.aws.codeartifact.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codeartifact.model.primitives.{
  PackageName,
  AssetName,
  AccountId,
  BooleanOptional,
  DomainName,
  SHA256,
  RepositoryName,
  PackageVersion,
  PackageNamespace
}
import scala.jdk.CollectionConverters._
final case class PublishPackageVersionRequest(
    domain: DomainName,
    domainOwner: Optional[AccountId] = Optional.Absent,
    repository: RepositoryName,
    format: zio.aws.codeartifact.model.PackageFormat,
    namespace: Optional[PackageNamespace] = Optional.Absent,
    packageValue: PackageName,
    packageVersion: PackageVersion,
    assetName: AssetName,
    assetSHA256: SHA256,
    unfinished: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codeartifact.model.PublishPackageVersionRequest = {
    import PublishPackageVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codeartifact.model.PublishPackageVersionRequest
      .builder()
      .domain(DomainName.unwrap(domain): java.lang.String)
      .optionallyWith(
        domainOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.domainOwner)
      .repository(RepositoryName.unwrap(repository): java.lang.String)
      .format(format.unwrap)
      .optionallyWith(
        namespace.map(value => PackageNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .packageValue(PackageName.unwrap(packageValue): java.lang.String)
      .packageVersion(PackageVersion.unwrap(packageVersion): java.lang.String)
      .assetName(AssetName.unwrap(assetName): java.lang.String)
      .assetSHA256(SHA256.unwrap(assetSHA256): java.lang.String)
      .optionallyWith(unfinished.map(value => value: java.lang.Boolean))(
        _.unfinished
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codeartifact.model.PublishPackageVersionRequest.ReadOnly =
    zio.aws.codeartifact.model.PublishPackageVersionRequest
      .wrap(buildAwsValue())
}
object PublishPackageVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codeartifact.model.PublishPackageVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codeartifact.model.PublishPackageVersionRequest =
      zio.aws.codeartifact.model.PublishPackageVersionRequest(
        domain,
        domainOwner.map(value => value),
        repository,
        format,
        namespace.map(value => value),
        packageValue,
        packageVersion,
        assetName,
        assetSHA256,
        unfinished.map(value => value)
      )
    def domain: DomainName
    def domainOwner: Optional[AccountId]
    def repository: RepositoryName
    def format: zio.aws.codeartifact.model.PackageFormat
    def namespace: Optional[PackageNamespace]
    def packageValue: PackageName
    def packageVersion: PackageVersion
    def assetName: AssetName
    def assetSHA256: SHA256
    def unfinished: Optional[BooleanOptional]
    def getDomain: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domain)
    def getDomainOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("domainOwner", domainOwner)
    def getRepository: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repository)
    def getFormat: ZIO[Any, Nothing, zio.aws.codeartifact.model.PackageFormat] =
      ZIO.succeed(format)
    def getNamespace: ZIO[Any, AwsError, PackageNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getPackageValue: ZIO[Any, Nothing, PackageName] =
      ZIO.succeed(packageValue)
    def getPackageVersion: ZIO[Any, Nothing, PackageVersion] =
      ZIO.succeed(packageVersion)
    def getAssetName: ZIO[Any, Nothing, AssetName] = ZIO.succeed(assetName)
    def getAssetSHA256: ZIO[Any, Nothing, SHA256] = ZIO.succeed(assetSHA256)
    def getUnfinished: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("unfinished", unfinished)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codeartifact.model.PublishPackageVersionRequest
  ) extends zio.aws.codeartifact.model.PublishPackageVersionRequest.ReadOnly {
    override val domain: DomainName =
      zio.aws.codeartifact.model.primitives.DomainName(impl.domain())
    override val domainOwner: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.domainOwner())
      .map(value => zio.aws.codeartifact.model.primitives.AccountId(value))
    override val repository: RepositoryName =
      zio.aws.codeartifact.model.primitives.RepositoryName(impl.repository())
    override val format: zio.aws.codeartifact.model.PackageFormat =
      zio.aws.codeartifact.model.PackageFormat.wrap(impl.format())
    override val namespace: Optional[PackageNamespace] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value =>
        zio.aws.codeartifact.model.primitives.PackageNamespace(value)
      )
    override val packageValue: PackageName =
      zio.aws.codeartifact.model.primitives.PackageName(impl.packageValue())
    override val packageVersion: PackageVersion =
      zio.aws.codeartifact.model.primitives
        .PackageVersion(impl.packageVersion())
    override val assetName: AssetName =
      zio.aws.codeartifact.model.primitives.AssetName(impl.assetName())
    override val assetSHA256: SHA256 =
      zio.aws.codeartifact.model.primitives.SHA256(impl.assetSHA256())
    override val unfinished: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.unfinished())
      .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codeartifact.model.PublishPackageVersionRequest
  ): zio.aws.codeartifact.model.PublishPackageVersionRequest.ReadOnly =
    new Wrapper(impl)
}
